/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwe.enc;

import org.keycloak.jose.jwe.enc.AesGcmEncryptionProvider;

public class AesGcmJWEEncryptionProvider
extends AesGcmEncryptionProvider {
    private final int expectedAesKeyLength;
    private final int expectedCEKLength;

    public AesGcmJWEEncryptionProvider(String jwaAlgorithmName) {
        if ("A128GCM".equals(jwaAlgorithmName)) {
            this.expectedAesKeyLength = 16;
            this.expectedCEKLength = 16;
        } else if ("A192GCM".equals(jwaAlgorithmName)) {
            this.expectedAesKeyLength = 24;
            this.expectedCEKLength = 24;
        } else if ("A256GCM".equals(jwaAlgorithmName)) {
            this.expectedAesKeyLength = 32;
            this.expectedCEKLength = 32;
        } else {
            this.expectedAesKeyLength = 0;
            this.expectedCEKLength = 0;
        }
    }

    @Override
    protected int getExpectedAesKeyLength() {
        return this.expectedAesKeyLength;
    }

    @Override
    public int getExpectedCEKLength() {
        return this.expectedCEKLength;
    }
}

