/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.cli.util;

import java.io.InputStream;
import java.util.Map;
import org.keycloak.client.cli.util.Headers;
import org.keycloak.client.cli.util.HeadersBody;
import org.keycloak.client.cli.util.HttpResponseException;
import org.keycloak.util.JsonSerialization;

public class HeadersBodyStatus
extends HeadersBody {
    private final String status;

    public HeadersBodyStatus(String status, Headers headers, InputStream body) {
        super(headers, body);
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    private String getStatusCodeAndReason() {
        return this.getStatus().substring(9);
    }

    public void checkSuccess() {
        int code = this.getStatusCode();
        if (code < 200 || code >= 300) {
            String content = this.readBodyString();
            Map error = null;
            try {
                error = JsonSerialization.readValue(content, Map.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String message = null;
            if (error != null) {
                String description = (String)error.get("error_description");
                String err = (String)error.get("error");
                String msg = (String)error.get("errorMessage");
                message = msg != null ? msg : (err != null ? description + " [" + (String)error.get("error") + "]" : null);
            }
            throw new HttpResponseException(this.getStatusCodeAndReason(), message, new RuntimeException(content));
        }
    }

    public int getStatusCode() {
        return Integer.valueOf(this.status.split(" ")[1]);
    }
}

