/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd;

import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.federation.sssd.SSSDFederationProvider;
import org.keycloak.federation.sssd.impl.AvailabilityChecker;
import org.keycloak.federation.sssd.impl.PAMAuthenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;

public class SSSDFederationProviderFactory
implements UserStorageProviderFactory<SSSDFederationProvider>,
EnvironmentDependentProviderFactory {
    private static final String PROVIDER_NAME = "sssd";
    private static final Logger logger = Logger.getLogger(SSSDFederationProvider.class);
    private volatile DBusConnection dbusConnection;

    public String getId() {
        return PROVIDER_NAME;
    }

    public SSSDFederationProvider create(KeycloakSession session, ComponentModel model) {
        this.lazyInit();
        return new SSSDFederationProvider(session, new UserStorageProviderModel(model), this);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        if (this.dbusConnection != null) {
            this.dbusConnection.disconnect();
        }
    }

    protected PAMAuthenticator createPAMAuthenticator(String username, String ... factors) {
        return new PAMAuthenticator(username, factors);
    }

    protected DBusConnection getDbusConnection() {
        return this.dbusConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.dbusConnection == null) {
            SSSDFederationProviderFactory sSSDFederationProviderFactory = this;
            synchronized (sSSDFederationProviderFactory) {
                if (this.dbusConnection == null) {
                    try {
                        this.dbusConnection = DBusConnectionBuilder.forSystemBus().build();
                    }
                    catch (DBusException e) {
                        throw new IllegalStateException("Cannot create DBUS connection", e);
                    }
                }
            }
        }
    }

    public boolean isSupported(Config.Scope config) {
        return AvailabilityChecker.isAvailable();
    }
}

