/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.resource;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class MemoryInputStream
extends InputStream {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final ByteBuffer CLOSED = ByteBuffer.allocateDirect(0);
    ByteBuffer buf;
    int mark = -1;

    public MemoryInputStream(ByteBuffer buffer) {
        this.buf = buffer.duplicate();
    }

    public MemoryInputStream(byte[] bytes) {
        this(ByteBuffer.wrap(bytes));
    }

    @Override
    public int read() throws IOException {
        ByteBuffer buf = this.buf;
        MemoryInputStream.checkClosed(buf);
        return buf.hasRemaining() ? Byte.toUnsignedInt(buf.get()) : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Objects.checkFromIndexSize(off, len, b.length);
        ByteBuffer buf = this.buf;
        MemoryInputStream.checkClosed(buf);
        int rem = buf.remaining();
        if (rem == 0) {
            return -1;
        }
        int cnt = Math.min(len, rem);
        buf.get(b, off, cnt);
        return cnt;
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        ByteBuffer buf = this.buf;
        MemoryInputStream.checkClosed(buf);
        int rem = buf.remaining();
        if (rem == 0) {
            return EMPTY_BYTES;
        }
        byte[] bytes = new byte[rem];
        buf.get(bytes);
        return bytes;
    }

    @Override
    public long skip(long n) throws IOException {
        ByteBuffer buf = this.buf;
        MemoryInputStream.checkClosed(buf);
        int pos = buf.position();
        int lim = buf.limit();
        int cnt = (int)Math.min(n, (long)(lim - pos));
        if (cnt > 0) {
            buf.position(pos + cnt);
        }
        return cnt;
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        ByteBuffer buf = this.buf;
        MemoryInputStream.checkClosed(buf);
        int pos = buf.position();
        int lim = buf.limit();
        if (pos == lim) {
            return 0L;
        }
        if (out instanceof FileOutputStream) {
            FileOutputStream fos = (FileOutputStream)out;
            return fos.getChannel().write(buf);
        }
        int rem = lim - pos;
        if (buf.hasArray()) {
            int offs = buf.arrayOffset() + pos;
            out.write(buf.array(), offs, rem);
            buf.position(lim);
            return rem;
        }
        if (rem <= 8192) {
            byte[] b = this.readAllBytes();
            out.write(b);
            return b.length;
        }
        return super.transferTo(out);
    }

    @Override
    public void mark(int bytes) {
        this.mark = this.buf.position();
    }

    @Override
    public void reset() throws IOException {
        ByteBuffer buf = this.buf;
        MemoryInputStream.checkClosed(buf);
        int mark = this.mark;
        if (mark == -1) {
            throw new IOException("No mark set");
        }
        buf.position(mark);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int available() {
        return this.buf.remaining();
    }

    @Override
    public void close() {
        this.buf = CLOSED;
    }

    private static void checkClosed(ByteBuffer buf) throws IOException {
        if (buf == CLOSED) {
            throw new IOException("Stream closed");
        }
    }
}

