/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.logging;

import io.quarkus.logging.LoggingFilter;
import java.util.Objects;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import org.keycloak.common.util.MultiSiteUtils;

@LoggingFilter(name="keycloak-filter")
public final class KeycloakLogFilter
implements Filter {
    private static final Pattern ISPN000312_PATTERN = Pattern.compile("^\\[Context=(" + String.join((CharSequence)"|", "sessions", "clientSessions", "offlineSessions", "offlineClientSessions") + ")] ISPN000312: .*");

    @Override
    public boolean isLoggable(LogRecord record) {
        if (Objects.equals(record.getLevel(), Level.WARNING) && record.getLoggerName().equals("com.arjuna.ats.arjuna") && record.getMessage().startsWith("ARJUNA012125:")) {
            return false;
        }
        return !MultiSiteUtils.isPersistentSessionsEnabled() || !Objects.equals(record.getLevel(), Level.WARNING) || !record.getLoggerName().equals("org.infinispan.CLUSTER") || !ISPN000312_PATTERN.matcher(record.getMessage()).matches();
    }
}

