/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.v1;

import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twitter4j.v1.GeoLocation;

public final class GeoQuery
implements Serializable {
    private static final long serialVersionUID = 5434503339001056634L;
    @Nullable
    public final GeoLocation location;
    public final String query;
    @Nullable
    public final String ip;
    @Nullable
    public final String accuracy;
    @Nullable
    public final String granularity;
    public final int maxResults;

    private GeoQuery(@Nullable GeoLocation location, String query, @Nullable String ip, @Nullable String accuracy, @Nullable String granularity, int maxResults) {
        this.location = location;
        this.query = query;
        this.ip = ip;
        this.accuracy = accuracy;
        this.granularity = granularity;
        this.maxResults = maxResults;
    }

    public static GeoQuery ofGeoLocation(double latitude, double longitude) {
        return new GeoQuery(GeoLocation.of(latitude, longitude), null, null, null, null, -1);
    }

    public GeoQuery geoLocation(double latitude, double longitude) {
        return new GeoQuery(GeoLocation.of(latitude, longitude), this.query, this.ip, this.accuracy, this.granularity, this.maxResults);
    }

    public static GeoQuery ofIP(String ip) {
        return new GeoQuery(null, null, ip, null, null, -1);
    }

    public GeoQuery ip(String ip) {
        return new GeoQuery(this.location, this.query, ip, this.accuracy, this.granularity, this.maxResults);
    }

    public static GeoQuery ofQuery(@NotNull String query) {
        return new GeoQuery(null, query, null, null, null, -1);
    }

    public GeoQuery query(@NotNull String query) {
        return new GeoQuery(this.location, query, this.ip, this.accuracy, this.granularity, this.maxResults);
    }

    public GeoQuery accuracy(@NotNull String accuracy) {
        return new GeoQuery(this.location, this.query, this.ip, accuracy, this.granularity, this.maxResults);
    }

    public GeoQuery granularity(@NotNull String granularity) {
        return new GeoQuery(this.location, this.query, this.ip, this.accuracy, granularity, this.maxResults);
    }

    public GeoQuery maxResults(int maxResults) {
        return new GeoQuery(this.location, this.query, this.ip, this.accuracy, this.granularity, maxResults);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoQuery geoQuery = (GeoQuery)o;
        if (this.maxResults != geoQuery.maxResults) {
            return false;
        }
        if (!Objects.equals(this.accuracy, geoQuery.accuracy)) {
            return false;
        }
        if (!Objects.equals(this.granularity, geoQuery.granularity)) {
            return false;
        }
        if (!Objects.equals(this.ip, geoQuery.ip)) {
            return false;
        }
        return Objects.equals(this.location, geoQuery.location);
    }

    public int hashCode() {
        int result = this.location != null ? this.location.hashCode() : 0;
        result = 31 * result + (this.ip != null ? this.ip.hashCode() : 0);
        result = 31 * result + (this.accuracy != null ? this.accuracy.hashCode() : 0);
        result = 31 * result + (this.granularity != null ? this.granularity.hashCode() : 0);
        result = 31 * result + this.maxResults;
        return result;
    }

    public String toString() {
        return "GeoQuery{location=" + this.location + ", query='" + this.query + '\'' + ", ip='" + this.ip + '\'' + ", accuracy='" + this.accuracy + '\'' + ", granularity='" + this.granularity + '\'' + ", maxResults=" + this.maxResults + '}';
    }
}

