/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ContextCreator;
import io.quarkus.arc.CurrentContextFactory;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.context.NormalScope;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ContextConfigurator {
    private final AtomicBoolean consumed = new AtomicBoolean(false);
    private final Consumer<ContextConfigurator> configuratorConsumer;
    Class<? extends Annotation> scopeAnnotation;
    boolean isNormal;
    Function<MethodCreator, ResultHandle> creator;
    final Map<String, Object> params;

    ContextConfigurator(Class<? extends Annotation> scopeAnnotation, Consumer<ContextConfigurator> configuratorConsumer) {
        this.scopeAnnotation = Objects.requireNonNull(scopeAnnotation);
        this.params = new HashMap<String, Object>();
        this.configuratorConsumer = configuratorConsumer;
        this.isNormal = scopeAnnotation.isAnnotationPresent(NormalScope.class);
    }

    public ContextConfigurator param(String name, Class<?> value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, int value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, long value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, double value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, boolean value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator normal() {
        return this.normal(true);
    }

    public ContextConfigurator normal(boolean value) {
        this.isNormal = value;
        return this;
    }

    public ContextConfigurator contextClass(final Class<? extends InjectableContext> contextClazz) {
        if (!Modifier.isPublic(contextClazz.getModifiers()) || Modifier.isAbstract(contextClazz.getModifiers()) || contextClazz.isAnonymousClass() || contextClazz.isLocalClass() || contextClazz.getEnclosingClass() != null && !Modifier.isStatic(contextClazz.getModifiers())) {
            throw new IllegalArgumentException("A context class must be a public non-abstract top-level or static nested class");
        }
        final Constructor<?> constructor = this.getConstructor(contextClazz);
        if (constructor == null) {
            throw new IllegalArgumentException("A context class must either declare a no-args constructor or a constructor that accepts a single parameter of type io.quarkus.arc.CurrentContextFactory");
        }
        return this.creator(new Function<MethodCreator, ResultHandle>(){

            @Override
            public ResultHandle apply(MethodCreator mc) {
                ResultHandle[] args = constructor.getParameterCount() == 0 ? new ResultHandle[]{} : new ResultHandle[]{mc.getMethodParam(0)};
                return mc.newInstance(MethodDescriptor.ofConstructor((Class)contextClazz, (Class[])constructor.getParameterTypes()), args);
            }
        });
    }

    private Constructor<?> getConstructor(Class<? extends InjectableContext> contextClazz) {
        Constructor<? extends InjectableContext> constructor = null;
        try {
            constructor = contextClazz.getDeclaredConstructor(CurrentContextFactory.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (constructor == null) {
            try {
                constructor = contextClazz.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return constructor;
    }

    public ContextConfigurator creator(Class<? extends ContextCreator> creatorClazz) {
        return this.creator((MethodCreator mc) -> {
            ResultHandle paramsHandle = mc.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
            mc.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, paramsHandle, new ResultHandle[]{mc.load("io.quarkus.arc.currentContextFactory"), mc.getMethodParam(0)});
            for (Map.Entry<String, Object> entry : this.params.entrySet()) {
                ResultHandle valHandle = null;
                if (entry.getValue() instanceof String) {
                    valHandle = mc.load(entry.getValue().toString());
                } else if (entry.getValue() instanceof Integer) {
                    valHandle = mc.newInstance(MethodDescriptor.ofConstructor(Integer.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{mc.load(((Integer)entry.getValue()).intValue())});
                } else if (entry.getValue() instanceof Long) {
                    valHandle = mc.newInstance(MethodDescriptor.ofConstructor(Long.class, (Class[])new Class[]{Long.TYPE}), new ResultHandle[]{mc.load(((Long)entry.getValue()).longValue())});
                } else if (entry.getValue() instanceof Double) {
                    valHandle = mc.newInstance(MethodDescriptor.ofConstructor(Double.class, (Class[])new Class[]{Double.TYPE}), new ResultHandle[]{mc.load(((Double)entry.getValue()).doubleValue())});
                } else if (entry.getValue() instanceof Class) {
                    valHandle = mc.loadClass((Class)entry.getValue());
                } else if (entry.getValue() instanceof Boolean) {
                    valHandle = mc.load(((Boolean)entry.getValue()).booleanValue());
                }
                mc.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, paramsHandle, new ResultHandle[]{mc.load(entry.getKey()), valHandle});
            }
            ResultHandle creatorHandle = mc.newInstance(MethodDescriptor.ofConstructor((Class)creatorClazz, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle ret = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(ContextCreator.class, (String)"create", InjectableContext.class, (Class[])new Class[]{Map.class}), creatorHandle, new ResultHandle[]{paramsHandle});
            return ret;
        });
    }

    public ContextConfigurator creator(Function<MethodCreator, ResultHandle> creator) {
        this.creator = creator;
        return this;
    }

    public void done() {
        if (this.consumed.compareAndSet(false, true)) {
            Objects.requireNonNull(this.creator);
            Objects.requireNonNull(this.configuratorConsumer).accept(this);
        }
    }
}

