/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import org.jgroups.Message;
import org.jgroups.util.Credit;
import org.jgroups.util.SizeBoundedQueue;
import org.jgroups.util.Util;

public class NonBlockingCredit
extends Credit {
    protected final SizeBoundedQueue<Message> msg_queue;
    protected boolean queuing;
    protected final Consumer<Message> send_function;
    protected static final Consumer<Message> NO_OP_SEND_FUNCTION = msg -> {};
    protected final LongAdder num_queued = new LongAdder();

    public NonBlockingCredit(long credits, int max_size, Lock lock) {
        this(credits, max_size, lock, NO_OP_SEND_FUNCTION);
    }

    public NonBlockingCredit(long credits, int max_size, Lock lock, Consumer<Message> send_function) {
        super(credits, lock);
        this.msg_queue = new SizeBoundedQueue(max_size, lock);
        this.send_function = send_function;
    }

    public boolean isQueuing() {
        return this.queuing;
    }

    public int getQueuedMessages() {
        return this.msg_queue.getElements();
    }

    public int getQueuedMessageSize() {
        return this.msg_queue.size();
    }

    public int getEnqueuedMessages() {
        return this.num_queued.intValue();
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_queued.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean decrementIfEnoughCredits(Message msg, int credits, long timeout) {
        this.lock.lock();
        try {
            if (this.done) {
                boolean bl = false;
                return bl;
            }
            if (this.queuing) {
                boolean bl = this.addToQueue(msg, credits);
                return bl;
            }
            if (this.decrement(credits)) {
                boolean bl = true;
                return bl;
            }
            this.queuing = true;
            boolean bl = this.addToQueue(msg, credits);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increment(long credits, long max_credits) {
        ArrayList drain_list;
        this.lock.lock();
        try {
            super.increment(credits, max_credits);
            if (!this.queuing || this.msg_queue.isEmpty()) {
                return;
            }
            drain_list = new ArrayList(this.msg_queue.getElements());
            int drained = this.msg_queue.drainTo(drain_list, (int)this.credits_left);
            if (drained > 0) {
                this.credits_left = Math.min(max_credits, this.credits_left - (long)drained);
            }
            if (this.msg_queue.isEmpty()) {
                this.queuing = false;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!drain_list.isEmpty()) {
            drain_list.forEach(this.send_function);
        }
    }

    @Override
    public Credit reset() {
        this.lock.lock();
        try {
            super.reset();
            this.queuing = false;
            this.msg_queue.clear(true);
            NonBlockingCredit nonBlockingCredit = this;
            return nonBlockingCredit;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String toString() {
        return String.format("%s bytes left (queuing: %b, msg-queue size: %d, bytes: %s, enqueued: %d)", super.toString(), this.isQueuing(), this.getQueuedMessages(), Util.printBytes(this.getQueuedMessageSize()), this.num_queued.intValue());
    }

    protected boolean addToQueue(Message msg, int length) {
        try {
            this.msg_queue.add(msg, length);
            this.num_queued.increment();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }
}

