/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.concurrent.ThreadLocalRandom;

public class ExponentialBackoff {
    private final long initialInterval;
    private final int multiplier;
    private final long maxInterval;
    private final double jitter;
    private final double expMax;

    public ExponentialBackoff(long initialInterval, int multiplier, long maxInterval, double jitter) {
        this.initialInterval = Math.min(maxInterval, initialInterval);
        this.multiplier = multiplier;
        this.maxInterval = maxInterval;
        if (jitter < 0.0 || jitter > 1.0) {
            throw new IllegalArgumentException(String.format("jitter must be between 0 and 1, but got %s", jitter));
        }
        this.jitter = jitter;
        this.expMax = maxInterval > initialInterval ? Math.log((double)maxInterval / (double)Math.max(initialInterval, 1L)) / Math.log(multiplier) : 0.0;
    }

    public long initialInterval() {
        return this.initialInterval;
    }

    public long backoff(long attempts) {
        if (this.expMax == 0.0) {
            return this.initialInterval;
        }
        double exp = Math.min((double)attempts, this.expMax);
        double term = (double)this.initialInterval * Math.pow(this.multiplier, exp);
        double randomFactor = this.jitter < Double.MIN_NORMAL ? 1.0 : ThreadLocalRandom.current().nextDouble(1.0 - this.jitter, 1.0 + this.jitter);
        long backoffValue = (long)(randomFactor * term);
        return Math.min(backoffValue, this.maxInterval);
    }

    public String toString() {
        return "ExponentialBackoff{multiplier=" + this.multiplier + ", expMax=" + this.expMax + ", initialInterval=" + this.initialInterval + ", jitter=" + this.jitter + "}";
    }
}

