/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogReadResult;
import org.apache.kafka.storage.internals.log.RemoteLogReadResult;
import org.apache.kafka.storage.internals.log.RemoteStorageFetchInfo;

public class PendingRemoteFetches {
    private final List<RemoteFetch> remoteFetches;
    private final LinkedHashMap<TopicIdPartition, LogOffsetMetadata> fetchOffsetMetadataMap;

    PendingRemoteFetches(List<RemoteFetch> remoteFetches, LinkedHashMap<TopicIdPartition, LogOffsetMetadata> fetchOffsetMetadataMap) {
        this.remoteFetches = remoteFetches;
        this.fetchOffsetMetadataMap = fetchOffsetMetadataMap;
    }

    public boolean isDone() {
        for (RemoteFetch remoteFetch : this.remoteFetches) {
            if (remoteFetch.remoteFetchResult.isDone()) continue;
            return false;
        }
        return true;
    }

    public void invokeCallbackOnCompletion(BiConsumer<Void, Throwable> callback) {
        ArrayList remoteFetchResult = new ArrayList();
        this.remoteFetches.forEach(remoteFetch -> remoteFetchResult.add(remoteFetch.remoteFetchResult()));
        CompletableFuture.allOf(remoteFetchResult.toArray(new CompletableFuture[0])).whenComplete((BiConsumer)callback);
    }

    public List<RemoteFetch> remoteFetches() {
        return this.remoteFetches;
    }

    public LinkedHashMap<TopicIdPartition, LogOffsetMetadata> fetchOffsetMetadataMap() {
        return this.fetchOffsetMetadataMap;
    }

    public String toString() {
        return "PendingRemoteFetches(remoteFetches=" + String.valueOf(this.remoteFetches) + ", fetchOffsetMetadataMap=" + String.valueOf(this.fetchOffsetMetadataMap) + ")";
    }

    public record RemoteFetch(TopicIdPartition topicIdPartition, LogReadResult logReadResult, Future<Void> remoteFetchTask, CompletableFuture<RemoteLogReadResult> remoteFetchResult, RemoteStorageFetchInfo remoteFetchInfo) {
        @Override
        public String toString() {
            return "RemoteFetch(topicIdPartition=" + String.valueOf(this.topicIdPartition) + ", logReadResult=" + String.valueOf(this.logReadResult) + ", remoteFetchTask=" + String.valueOf(this.remoteFetchTask) + ", remoteFetchResult=" + String.valueOf(this.remoteFetchResult) + ", remoteFetchInfo=" + String.valueOf(this.remoteFetchInfo) + ")";
        }
    }
}

