/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafka.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafka.clients.admin.RenewDelegationTokenOptions;
import org.apache.kafka.clients.admin.RenewDelegationTokenResult;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.TerseException;

public class DelegationTokenCommand {
    public static void main(String ... args) {
        Exit.exit((int)DelegationTokenCommand.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        try {
            DelegationTokenCommand.execute(args);
            return 0;
        }
        catch (TerseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            return 1;
        }
    }

    static void execute(String ... args) throws Exception {
        DelegationTokenCommandOptions opts = new DelegationTokenCommandOptions(args);
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)opts, (String)"This tool helps to create, renew, expire, or describe delegation tokens.");
        long numberOfActions = Stream.of(opts.hasCreateOpt(), opts.hasRenewOpt(), opts.hasExpireOpt(), opts.hasDescribeOpt()).filter(b -> b).count();
        if (numberOfActions != 1L) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)"Command must include exactly one action: --create, --renew, --expire or --describe");
        }
        opts.checkArgs();
        try (Admin adminClient = DelegationTokenCommand.createAdminClient(opts);){
            if (opts.hasCreateOpt()) {
                DelegationTokenCommand.createToken(adminClient, opts);
            } else if (opts.hasRenewOpt()) {
                DelegationTokenCommand.renewToken(adminClient, opts);
            } else if (opts.hasExpireOpt()) {
                DelegationTokenCommand.expireToken(adminClient, opts);
            } else if (opts.hasDescribeOpt()) {
                DelegationTokenCommand.describeToken(adminClient, opts);
            }
        }
    }

    public static DelegationToken createToken(Admin adminClient, DelegationTokenCommandOptions opts) throws ExecutionException, InterruptedException {
        List<KafkaPrincipal> renewerPrincipals = DelegationTokenCommand.getPrincipals(opts, opts.renewPrincipalsOpt);
        Long maxLifeTimeMs = opts.maxLifeTime();
        System.out.println("Calling create token operation with renewers :" + String.valueOf(renewerPrincipals) + " , max-life-time-period :" + maxLifeTimeMs);
        CreateDelegationTokenOptions createDelegationTokenOptions = new CreateDelegationTokenOptions().maxLifetimeMs(maxLifeTimeMs.longValue()).renewers(renewerPrincipals);
        List<KafkaPrincipal> ownerPrincipals = DelegationTokenCommand.getPrincipals(opts, opts.ownerPrincipalsOpt);
        if (!ownerPrincipals.isEmpty()) {
            createDelegationTokenOptions.owner(ownerPrincipals.get(0));
        }
        CreateDelegationTokenResult createResult = adminClient.createDelegationToken(createDelegationTokenOptions);
        DelegationToken token = (DelegationToken)createResult.delegationToken().get();
        System.out.println("Created delegation token with tokenId : " + token.tokenInfo().tokenId());
        DelegationTokenCommand.printToken(Collections.singletonList(token));
        return token;
    }

    private static void printToken(List<DelegationToken> tokens) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        System.out.printf("%n%-15s %-30s %-15s %-15s %-25s %-15s %-15s %-15s%n", "TOKENID", "HMAC", "OWNER", "REQUESTER", "RENEWERS", "ISSUEDATE", "EXPIRYDATE", "MAXDATE");
        for (DelegationToken token : tokens) {
            TokenInformation tokenInfo = token.tokenInfo();
            System.out.printf("%n%-15s %-30s %-15s %-15s %-25s %-15s %-15s %-15s%n", tokenInfo.tokenId(), token.hmacAsBase64String(), tokenInfo.owner(), tokenInfo.tokenRequester(), tokenInfo.renewersAsString(), dateFormat.format(tokenInfo.issueTimestamp()), dateFormat.format(tokenInfo.expiryTimestamp()), dateFormat.format(tokenInfo.maxTimestamp()));
        }
    }

    private static List<KafkaPrincipal> getPrincipals(DelegationTokenCommandOptions opts, OptionSpec<String> principalOptionSpec) {
        ArrayList<KafkaPrincipal> principals = new ArrayList<KafkaPrincipal>();
        if (opts.options.has(principalOptionSpec)) {
            for (String e : opts.options.valuesOf(principalOptionSpec)) {
                principals.add(SecurityUtils.parseKafkaPrincipal((String)e.trim()));
            }
        }
        return principals;
    }

    public static Long renewToken(Admin adminClient, DelegationTokenCommandOptions opts) throws ExecutionException, InterruptedException {
        String hmac = opts.hmac();
        Long renewTimePeriodMs = opts.renewTimePeriod();
        System.out.println("Calling renew token operation with hmac :" + hmac + " , renew-time-period :" + renewTimePeriodMs);
        RenewDelegationTokenResult renewResult = adminClient.renewDelegationToken(Base64.getDecoder().decode(hmac), new RenewDelegationTokenOptions().renewTimePeriodMs(renewTimePeriodMs.longValue()));
        Long expiryTimeStamp = (Long)renewResult.expiryTimestamp().get();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        System.out.printf("Completed renew operation. New expiry date : %s", dateFormat.format(expiryTimeStamp));
        return expiryTimeStamp;
    }

    public static void expireToken(Admin adminClient, DelegationTokenCommandOptions opts) throws ExecutionException, InterruptedException {
        String hmac = opts.hmac();
        Long expiryTimePeriodMs = opts.expiryTimePeriod();
        System.out.println("Calling expire token operation with hmac :" + hmac + " , expire-time-period :" + expiryTimePeriodMs);
        ExpireDelegationTokenResult renewResult = adminClient.expireDelegationToken(Base64.getDecoder().decode(hmac), new ExpireDelegationTokenOptions().expiryTimePeriodMs(expiryTimePeriodMs.longValue()));
        Long expiryTimeStamp = (Long)renewResult.expiryTimestamp().get();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        System.out.printf("Completed expire operation. New expiry date : %s", dateFormat.format(expiryTimeStamp));
    }

    public static List<DelegationToken> describeToken(Admin adminClient, DelegationTokenCommandOptions opts) throws ExecutionException, InterruptedException {
        List<KafkaPrincipal> ownerPrincipals = DelegationTokenCommand.getPrincipals(opts, opts.ownerPrincipalsOpt);
        if (ownerPrincipals.isEmpty()) {
            System.out.println("Calling describe token operation for current user.");
        } else {
            System.out.printf("Calling describe token operation for owners: %s%n", ownerPrincipals);
        }
        DescribeDelegationTokenResult describeResult = adminClient.describeDelegationToken(new DescribeDelegationTokenOptions().owners(ownerPrincipals));
        List tokens = (List)describeResult.delegationTokens().get();
        System.out.printf("Total number of tokens : %d", tokens.size());
        DelegationTokenCommand.printToken(tokens);
        return tokens;
    }

    private static Admin createAdminClient(DelegationTokenCommandOptions opts) throws IOException {
        Properties props = Utils.loadProps((String)((String)opts.options.valueOf(opts.commandConfigOpt)));
        props.put("bootstrap.servers", opts.options.valueOf(opts.bootstrapServerOpt));
        return Admin.create((Properties)props);
    }

    static class DelegationTokenCommandOptions
    extends CommandDefaultOptions {
        public final OptionSpec<String> bootstrapServerOpt;
        public final OptionSpec<String> commandConfigOpt;
        public final OptionSpec<Void> createOpt;
        public final OptionSpec<Void> renewOpt;
        public final OptionSpec<Void> expiryOpt;
        public final OptionSpec<Void> describeOpt;
        public final OptionSpec<String> ownerPrincipalsOpt;
        public final OptionSpec<String> renewPrincipalsOpt;
        public final OptionSpec<Long> maxLifeTimeOpt;
        public final OptionSpec<Long> renewTimePeriodOpt;
        public final OptionSpec<Long> expiryTimePeriodOpt;
        public final OptionSpec<String> hmacOpt;

        public DelegationTokenCommandOptions(String[] args) {
            super(args);
            String bootstrapServerDoc = "REQUIRED: server(s) to use for bootstrapping.";
            String commandConfigDoc = "REQUIRED: A property file containing configs to be passed to Admin Client. Token management operations are allowed in secure mode only. This config file is used to pass security related configs.";
            this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", bootstrapServerDoc).withRequiredArg().ofType(String.class);
            this.commandConfigOpt = this.parser.accepts("command-config", commandConfigDoc).withRequiredArg().ofType(String.class);
            this.createOpt = this.parser.accepts("create", "Create a new delegation token. Use --renewer-principal option to pass renewer principals.");
            this.renewOpt = this.parser.accepts("renew", "Renew delegation token. Use --renew-time-period option to set renew time period.");
            this.expiryOpt = this.parser.accepts("expire", "Expire delegation token. Use --expiry-time-period option to expire the token.");
            this.describeOpt = this.parser.accepts("describe", "Describe delegation tokens for the given principals. Use --owner-principal to pass owner/renewer principals. If --owner-principal option is not supplied, all the user-owned tokens and tokens where the user has Describe permissions will be returned.");
            this.ownerPrincipalsOpt = this.parser.accepts("owner-principal", "owner is a Kafka principal. They should be in principalType:name format.").withOptionalArg().ofType(String.class);
            this.renewPrincipalsOpt = this.parser.accepts("renewer-principal", "renewer is a Kafka principal. They should be in principalType:name format.").withOptionalArg().ofType(String.class);
            this.maxLifeTimeOpt = this.parser.accepts("max-life-time-period", "Max life period for the token in milliseconds. If the value is -1, then token max life time will default to the server side config value of (delegation.token.max.lifetime.ms).").withOptionalArg().ofType(Long.class);
            this.renewTimePeriodOpt = this.parser.accepts("renew-time-period", "Renew time period in milliseconds. If the value is -1, then the renew time period will default to the server side config value of (delegation.token.expiry.time.ms).").withOptionalArg().ofType(Long.class);
            this.expiryTimePeriodOpt = this.parser.accepts("expiry-time-period", "Expiry time period in milliseconds. If the value is -1, then the token will get invalidated immediately.").withOptionalArg().ofType(Long.class);
            this.hmacOpt = this.parser.accepts("hmac", "HMAC of the delegation token").withOptionalArg().ofType(String.class);
            this.options = this.parser.parse(args);
        }

        public boolean hasCreateOpt() {
            return this.options.has(this.createOpt);
        }

        public boolean hasRenewOpt() {
            return this.options.has(this.renewOpt);
        }

        public boolean hasExpireOpt() {
            return this.options.has(this.expiryOpt);
        }

        public boolean hasDescribeOpt() {
            return this.options.has(this.describeOpt);
        }

        public long maxLifeTime() {
            return (Long)this.options.valueOf(this.maxLifeTimeOpt);
        }

        public long renewTimePeriod() {
            return (Long)this.options.valueOf(this.renewTimePeriodOpt);
        }

        public long expiryTimePeriod() {
            return (Long)this.options.valueOf(this.expiryTimePeriodOpt);
        }

        public String hmac() {
            return (String)this.options.valueOf(this.hmacOpt);
        }

        public void checkArgs() {
            CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.bootstrapServerOpt, this.commandConfigOpt});
            if (this.options.has(this.createOpt)) {
                CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.maxLifeTimeOpt});
            }
            if (this.options.has(this.renewOpt)) {
                CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.hmacOpt, this.renewTimePeriodOpt});
            }
            if (this.options.has(this.expiryOpt)) {
                CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.hmacOpt, this.expiryTimePeriodOpt});
            }
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.createOpt, new HashSet<OptionSpec>(Arrays.asList(this.hmacOpt, this.renewTimePeriodOpt, this.expiryTimePeriodOpt)));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.renewOpt, new HashSet<OptionSpec>(Arrays.asList(this.renewPrincipalsOpt, this.maxLifeTimeOpt, this.expiryTimePeriodOpt, this.ownerPrincipalsOpt)));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.expiryOpt, new HashSet<OptionSpec>(Arrays.asList(this.renewOpt, this.maxLifeTimeOpt, this.renewTimePeriodOpt, this.ownerPrincipalsOpt)));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.describeOpt, new HashSet<OptionSpec>(Arrays.asList(this.renewTimePeriodOpt, this.maxLifeTimeOpt, this.hmacOpt, this.renewTimePeriodOpt, this.expiryTimePeriodOpt)));
        }
    }
}

