/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.NomineeState;
import org.apache.kafka.raft.ReplicaKey;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.internals.EpochElection;
import org.slf4j.Logger;

public class CandidateState
implements NomineeState {
    private final int localId;
    private final Uuid localDirectoryId;
    private final int epoch;
    private final EpochElection epochElection;
    private final Optional<LogOffsetMetadata> highWatermark;
    private final int electionTimeoutMs;
    private final Timer electionTimer;
    private final Logger log;

    protected CandidateState(Time time, int localId, Uuid localDirectoryId, int epoch, VoterSet voters, Optional<LogOffsetMetadata> highWatermark, int electionTimeoutMs, LogContext logContext) {
        if (!voters.isVoter(ReplicaKey.of(localId, localDirectoryId))) {
            throw new IllegalArgumentException(String.format("Local replica (%d, %s) must be in the set of voters %s", localId, localDirectoryId, voters));
        }
        this.localId = localId;
        this.localDirectoryId = localDirectoryId;
        this.epoch = epoch;
        this.highWatermark = highWatermark;
        this.electionTimeoutMs = electionTimeoutMs;
        this.electionTimer = time.timer((long)electionTimeoutMs);
        this.log = logContext.logger(CandidateState.class);
        this.epochElection = new EpochElection(voters.voterKeys());
        this.epochElection.recordVote(localId, true);
    }

    @Override
    public EpochElection epochElection() {
        return this.epochElection;
    }

    @Override
    public boolean recordGrantedVote(int remoteNodeId) {
        if (this.epochElection().isRejectedVoter(remoteNodeId)) {
            throw new IllegalArgumentException("Attempt to grant vote from node " + remoteNodeId + " which previously rejected our request");
        }
        return this.epochElection().recordVote(remoteNodeId, true);
    }

    @Override
    public boolean recordRejectedVote(int remoteNodeId) {
        if (this.epochElection().isGrantedVoter(remoteNodeId)) {
            throw new IllegalArgumentException("Attempt to reject vote from node " + remoteNodeId + " which previously granted our request");
        }
        return this.epochElection().recordVote(remoteNodeId, false);
    }

    @Override
    public boolean hasElectionTimeoutExpired(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.isExpired();
    }

    @Override
    public long remainingElectionTimeMs(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.remainingMs();
    }

    @Override
    public ElectionState election() {
        return ElectionState.withVotedCandidate(this.epoch, ReplicaKey.of(this.localId, this.localDirectoryId), this.epochElection.voterIds());
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public Endpoints leaderEndpoints() {
        return Endpoints.empty();
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        return this.highWatermark;
    }

    @Override
    public boolean canGrantVote(ReplicaKey replicaKey, boolean isLogUpToDate, boolean isPreVote) {
        if (isPreVote && isLogUpToDate) {
            return true;
        }
        this.log.debug("Rejecting Vote request (preVote={}) from replica ({}) since we are in CandidateState in epoch {} and the replica's log is up-to-date={}", new Object[]{isPreVote, replicaKey, this.epoch, isLogUpToDate});
        return false;
    }

    public String toString() {
        return String.format("CandidateState(localId=%d, localDirectoryId=%s, epoch=%d, epochElection=%s, highWatermark=%s, electionTimeoutMs=%d)", this.localId, this.localDirectoryId, this.epoch, this.epochElection(), this.highWatermark, this.electionTimeoutMs);
    }

    @Override
    public String name() {
        return "Candidate";
    }

    @Override
    public void close() {
    }
}

