/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.StreamsGroupHeartbeatRequestData;
import org.apache.kafka.common.message.StreamsGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.StreamsGroupHeartbeatResponse;

public class StreamsGroupHeartbeatRequest
extends AbstractRequest {
    public static final int LEAVE_GROUP_MEMBER_EPOCH = -1;
    public static final int LEAVE_GROUP_STATIC_MEMBER_EPOCH = -2;
    public static final int JOIN_GROUP_MEMBER_EPOCH = 0;
    private final StreamsGroupHeartbeatRequestData data;

    public StreamsGroupHeartbeatRequest(StreamsGroupHeartbeatRequestData data, short version) {
        super(ApiKeys.STREAMS_GROUP_HEARTBEAT, version);
        this.data = data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new StreamsGroupHeartbeatResponse(new StreamsGroupHeartbeatResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()));
    }

    @Override
    public StreamsGroupHeartbeatRequestData data() {
        return this.data;
    }

    public static StreamsGroupHeartbeatRequest parse(Readable readable, short version) {
        return new StreamsGroupHeartbeatRequest(new StreamsGroupHeartbeatRequestData(readable, version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<StreamsGroupHeartbeatRequest> {
        private final StreamsGroupHeartbeatRequestData data;

        public Builder(StreamsGroupHeartbeatRequestData data) {
            this(data, false);
        }

        public Builder(StreamsGroupHeartbeatRequestData data, boolean enableUnstableLastVersion) {
            super(ApiKeys.STREAMS_GROUP_HEARTBEAT, enableUnstableLastVersion);
            this.data = data;
        }

        @Override
        public StreamsGroupHeartbeatRequest build(short version) {
            return new StreamsGroupHeartbeatRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

