/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage.serialization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogSegmentMetadataSnapshot;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemoteLogSegmentMetadataSnapshotRecord;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogMetadataTransform;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;

public class RemoteLogSegmentMetadataSnapshotTransform
implements RemoteLogMetadataTransform<RemoteLogSegmentMetadataSnapshot> {
    @Override
    public ApiMessageAndVersion toApiMessageAndVersion(RemoteLogSegmentMetadataSnapshot segmentMetadata) {
        RemoteLogSegmentMetadataSnapshotRecord record = new RemoteLogSegmentMetadataSnapshotRecord().setSegmentId(segmentMetadata.segmentId()).setStartOffset(segmentMetadata.startOffset()).setEndOffset(segmentMetadata.endOffset()).setBrokerId(segmentMetadata.brokerId()).setEventTimestampMs(segmentMetadata.eventTimestampMs()).setMaxTimestampMs(segmentMetadata.maxTimestampMs()).setSegmentSizeInBytes(segmentMetadata.segmentSizeInBytes()).setSegmentLeaderEpochs(this.createSegmentLeaderEpochsEntry(segmentMetadata.segmentLeaderEpochs())).setRemoteLogSegmentState(segmentMetadata.state().id()).setTxnIndexEmpty(segmentMetadata.isTxnIdxEmpty());
        segmentMetadata.customMetadata().ifPresent(md -> record.setCustomMetadata(md.value()));
        return new ApiMessageAndVersion((ApiMessage)record, record.highestSupportedVersion());
    }

    private List<RemoteLogSegmentMetadataSnapshotRecord.SegmentLeaderEpochEntry> createSegmentLeaderEpochsEntry(Map<Integer, Long> leaderEpochs) {
        return leaderEpochs.entrySet().stream().map(entry -> new RemoteLogSegmentMetadataSnapshotRecord.SegmentLeaderEpochEntry().setLeaderEpoch((Integer)entry.getKey()).setOffset((Long)entry.getValue())).toList();
    }

    @Override
    public RemoteLogSegmentMetadataSnapshot fromApiMessageAndVersion(ApiMessageAndVersion apiMessageAndVersion) {
        RemoteLogSegmentMetadataSnapshotRecord record = (RemoteLogSegmentMetadataSnapshotRecord)apiMessageAndVersion.message();
        HashMap<Integer, Long> segmentLeaderEpochs = new HashMap<Integer, Long>();
        for (RemoteLogSegmentMetadataSnapshotRecord.SegmentLeaderEpochEntry segmentLeaderEpoch : record.segmentLeaderEpochs()) {
            segmentLeaderEpochs.put(segmentLeaderEpoch.leaderEpoch(), segmentLeaderEpoch.offset());
        }
        Optional<RemoteLogSegmentMetadata.CustomMetadata> customMetadata = Optional.ofNullable(record.customMetadata()).map(RemoteLogSegmentMetadata.CustomMetadata::new);
        return new RemoteLogSegmentMetadataSnapshot(record.segmentId(), record.startOffset(), record.endOffset(), record.maxTimestampMs(), record.brokerId(), record.eventTimestampMs(), record.segmentSizeInBytes(), customMetadata, RemoteLogSegmentState.forId((byte)record.remoteLogSegmentState()), segmentLeaderEpochs, record.txnIndexEmpty());
    }
}

