/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Utils;

public interface ServerSocketFactory {
    public static final ServerSocketFactory INSTANCE = new KafkaServerSocketFactory();

    public ServerSocketChannel openServerSocket(String var1, InetSocketAddress var2, int var3, int var4) throws IOException;

    public static class KafkaServerSocketFactory
    implements ServerSocketFactory {
        @Override
        public ServerSocketChannel openServerSocket(String listenerName, InetSocketAddress socketAddress, int listenBacklogSize, int recvBufferSize) throws IOException {
            ServerSocketChannel socketChannel = ServerSocketChannel.open();
            try {
                socketChannel.configureBlocking(false);
                if (recvBufferSize != -1) {
                    socketChannel.socket().setReceiveBufferSize(recvBufferSize);
                }
                socketChannel.socket().bind(socketAddress, listenBacklogSize);
            }
            catch (SocketException e) {
                Utils.closeQuietly((AutoCloseable)socketChannel, (String)"server socket");
                throw new KafkaException(String.format("Socket server failed to bind to %s:%d: %s.", socketAddress.getHostString(), socketAddress.getPort(), e.getMessage()), (Throwable)e);
            }
            return socketChannel;
        }
    }
}

