/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.spi.lifecycle;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openstreetmap.josm.spi.lifecycle.InitStatusListener;
import org.openstreetmap.josm.spi.lifecycle.InitializationSequence;
import org.openstreetmap.josm.spi.lifecycle.InitializationTask;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public final class Lifecycle {
    private static volatile InitStatusListener initStatusListener;
    private static volatile Runnable shutdownSequence;

    private Lifecycle() {
    }

    public static InitStatusListener getInitStatusListener() {
        return initStatusListener;
    }

    public static void setInitStatusListener(InitStatusListener listener) {
        initStatusListener = Objects.requireNonNull(listener);
    }

    public static Runnable getShutdownSequence() {
        return shutdownSequence;
    }

    public static void setShutdownSequence(Runnable sequence) {
        shutdownSequence = Objects.requireNonNull(sequence);
    }

    public static void initialize(InitializationSequence initSequence) {
        Lifecycle.runInitializationTasks(initSequence.beforeInitializationTasks());
        try {
            ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), Utils.newThreadFactory("main-init-%d", 5));
            for (Future i : service.invokeAll(initSequence.parallelInitializationTasks())) {
                i.get();
            }
            initSequence.asynchronousRunnableTasks().forEach(x -> {
                if (x != null) {
                    service.submit((Runnable)x);
                }
            });
            initSequence.asynchronousCallableTasks().forEach(x -> {
                if (x != null) {
                    service.submit(x);
                }
            });
            try {
                service.shutdown();
            }
            catch (SecurityException e) {
                Logging.log(Logging.LEVEL_ERROR, "Unable to shutdown executor service", e);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new JosmRuntimeException(ex);
        }
        catch (ExecutionException ex) {
            throw new JosmRuntimeException(ex);
        }
        Lifecycle.runInitializationTasks(initSequence.afterInitializationTasks());
    }

    private static void runInitializationTasks(List<InitializationTask> tasks) {
        for (InitializationTask task : tasks) {
            try {
                task.call();
            }
            catch (JosmRuntimeException e) {
                BugReport.intercept(e).warn();
            }
        }
    }

    public static boolean exitJosm(boolean exit, int exitCode) {
        if (shutdownSequence != null) {
            shutdownSequence.run();
        }
        if (exit) {
            System.exit(exitCode);
        }
        return true;
    }
}

