/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractParser;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.openstreetmap.josm.tools.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OsmChangesetContentParser {
    private final InputSource source;
    private final ChangesetDataSet data = new ChangesetDataSet();

    public OsmChangesetContentParser(InputStream source) {
        CheckParameterUtil.ensureParameterNotNull(source, "source");
        this.source = new InputSource(new InputStreamReader(source, StandardCharsets.UTF_8));
    }

    public OsmChangesetContentParser(String source) {
        CheckParameterUtil.ensureParameterNotNull(source, "source");
        this.source = new InputSource(new StringReader(source));
    }

    public ChangesetDataSet parse(ProgressMonitor progressMonitor) throws XmlParsingException {
        return this.parse(progressMonitor, false);
    }

    public ChangesetDataSet parse(ProgressMonitor progressMonitor, boolean useAnonymousUser) throws XmlParsingException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Parsing changeset content ...", new Object[0]));
            XmlUtils.parseSafeSAX(this.source, new Parser(useAnonymousUser));
        }
        catch (XmlParsingException e) {
            throw e;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XmlParsingException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
        return this.data;
    }

    public ChangesetDataSet parse() throws XmlParsingException {
        return this.parse(null, false);
    }

    private class Parser
    extends AbstractParser {
        private ChangesetDataSet.ChangesetModificationType currentModificationType;

        Parser(boolean useAnonymousUser) {
            this.useAnonymousUser = useAnonymousUser;
        }

        @Override
        protected void throwException(String message) throws XmlParsingException {
            throw new XmlParsingException(message).rememberLocation(this.locator);
        }

        @Override
        protected void throwException(String message, Exception e) throws XmlParsingException {
            throw new XmlParsingException(message, e).rememberLocation(this.locator);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (super.doStartElement(qName, atts)) {
                return;
            }
            switch (qName) {
                case "osmChange": {
                    break;
                }
                case "create": {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.CREATED;
                    break;
                }
                case "modify": {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.UPDATED;
                    break;
                }
                case "delete": {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.DELETED;
                    break;
                }
                default: {
                    Logging.warn(I18n.tr("Unsupported start element ''{0}'' in changeset content at position ({1},{2}). Skipping.", qName, this.locator.getLineNumber(), this.locator.getColumnNumber()));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (qName) {
                case "node": 
                case "way": 
                case "relation": {
                    if (this.currentModificationType == null) {
                        this.throwException(I18n.tr("Illegal document structure. Found node, way, or relation outside of ''create'', ''modify'', or ''delete''.", new Object[0]));
                    }
                    OsmChangesetContentParser.this.data.put(this.currentPrimitive, this.currentModificationType);
                    break;
                }
                case "create": 
                case "modify": 
                case "delete": {
                    this.currentModificationType = null;
                    break;
                }
                case "osmChange": 
                case "tag": 
                case "nd": 
                case "member": {
                    break;
                }
                default: {
                    Logging.warn(I18n.tr("Unsupported end element ''{0}'' in changeset content at position ({1},{2}). Skipping.", qName, this.locator.getLineNumber(), this.locator.getColumnNumber()));
                }
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.throwException(null, e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.throwException(null, e);
        }
    }
}

