/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import org.openstreetmap.josm.data.preferences.ListProperty;
import org.openstreetmap.josm.spi.preferences.Config;

public class JosmComboBoxModel<E>
extends AbstractListModel<E>
implements MutableComboBoxModel<E>,
Iterable<E> {
    private int maxSize = -1;
    protected ArrayList<E> elements = new ArrayList();
    protected Object selected;

    public void setSize(int size) {
        this.maxSize = size;
    }

    public Collection<E> asCollection() {
        return new ArrayList<E>(this.elements);
    }

    public int getIndexOf(E element) {
        return this.elements.indexOf(element);
    }

    protected void doAddElement(E element) {
        if (element != null && (this.maxSize == -1 || this.getSize() < this.maxSize)) {
            this.elements.add(element);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public void addElement(E element) {
        this.doAddElement(element);
        this.fireIntervalAdded(this, this.elements.size() - 1, this.elements.size() - 1);
    }

    @Override
    public void removeElement(Object elem) {
        int index = this.elements.indexOf(elem);
        if (elem == this.selected) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        if (this.elements.remove(elem)) {
            this.fireIntervalRemoved(this, index, index);
        }
    }

    @Override
    public void removeElementAt(int index) {
        E elem = this.getElementAt(index);
        if (elem == this.selected) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.elements.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void insertElementAt(E element, int index) {
        if (this.maxSize != -1 && this.maxSize <= this.getSize()) {
            this.removeElementAt(this.getSize() - 1);
        }
        this.elements.add(index, element);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void setSelectedItem(Object elem) {
        if (this.selected != null && !this.selected.equals(elem) || this.selected == null && elem != null) {
            this.selected = elem;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public int getSize() {
        return this.elements.size();
    }

    @Override
    public E getElementAt(int index) {
        if (index >= 0 && index < this.elements.size()) {
            return this.elements.get(index);
        }
        return null;
    }

    public void addAllElements(Collection<E> elems) {
        int index0 = this.elements.size();
        elems.forEach(this::doAddElement);
        int index1 = this.elements.size() - 1;
        if (index0 <= index1) {
            this.fireIntervalAdded(this, index0, index1);
        }
    }

    public void addAllElements(Collection<String> strings, Function<String, E> buildE) {
        int index0 = this.elements.size();
        strings.forEach(s -> this.doAddElement(buildE.apply((String)s)));
        int index1 = this.elements.size() - 1;
        if (index0 <= index1) {
            this.fireIntervalAdded(this, index0, index1);
        }
    }

    public E addTopElement(E newElement) {
        if (newElement.equals(this.getElementAt(0))) {
            return this.getElementAt(0);
        }
        this.removeElement(newElement);
        this.insertElementAt(newElement, 0);
        return newElement;
    }

    public void removeAllElements() {
        if (!this.elements.isEmpty()) {
            int lastIndex = this.elements.size() - 1;
            this.elements.clear();
            this.selected = null;
            this.fireIntervalRemoved(this, 0, lastIndex);
        } else {
            this.selected = null;
        }
    }

    public E find(String s) {
        return this.elements.stream().filter(o -> o.toString().equals(s)).findAny().orElse(null);
    }

    public Preferences prefs(Function<String, E> readE, Function<E, String> writeE) {
        return new Preferences(readE, writeE);
    }

    public final class Preferences {
        private final Function<String, E> readE;
        private final Function<E, String> writeE;

        private Preferences(Function<String, E> readE, Function<E, String> writeE) {
            this.readE = readE;
            this.writeE = writeE;
        }

        public void load(String key) {
            JosmComboBoxModel.this.removeAllElements();
            JosmComboBoxModel.this.addAllElements(Config.getPref().getList(key), this.readE);
        }

        public void load(String key, List<String> defaults) {
            JosmComboBoxModel.this.removeAllElements();
            JosmComboBoxModel.this.addAllElements(Config.getPref().getList(key, defaults), this.readE);
        }

        public void load(ListProperty prop) {
            JosmComboBoxModel.this.removeAllElements();
            JosmComboBoxModel.this.addAllElements((Collection<String>)prop.get(), this.readE);
        }

        public List<String> asStringList() {
            ArrayList<String> list = new ArrayList<String>(JosmComboBoxModel.this.getSize());
            JosmComboBoxModel.this.forEach(element -> list.add(this.writeE.apply(element)));
            return list;
        }

        public void save(String key) {
            Config.getPref().putList(key, this.asStringList());
        }

        public void save(ListProperty prop) {
            prop.put(this.asStringList());
        }
    }
}

