/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Color;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.tools.Logging;

public final class CompileSearchTextDecorator
implements DocumentListener {
    private final JTextComponent textComponent;
    private final String originalToolTipText;
    private SearchCompiler.Match filter;

    private CompileSearchTextDecorator(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.originalToolTipText = textComponent.getToolTipText();
        textComponent.getDocument().addDocumentListener(this);
    }

    public static CompileSearchTextDecorator decorate(JTextComponent f) {
        return new CompileSearchTextDecorator(f);
    }

    private void setFilter() {
        try {
            this.textComponent.setBackground(UIManager.getColor("TextField.background"));
            this.textComponent.setToolTipText(this.originalToolTipText);
            this.filter = SearchCompiler.compile(this.textComponent.getText());
        }
        catch (SearchParseError ex) {
            this.textComponent.setBackground(new Color(255, 224, 224));
            this.textComponent.setToolTipText(ex.getMessage());
            this.filter = SearchCompiler.Always.INSTANCE;
            Logging.debug(ex);
        }
        this.textComponent.firePropertyChange("filter", 0, 1);
    }

    public SearchCompiler.Match getMatch() {
        return this.filter;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setFilter();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setFilter();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setFilter();
    }
}

