/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.ExtensibleTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.imagery.CacheSettingsPanel;
import org.openstreetmap.josm.gui.preferences.imagery.CommonSettingsPanel;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryProvidersPanel;
import org.openstreetmap.josm.gui.preferences.imagery.TMSSettingsPanel;
import org.openstreetmap.josm.gui.preferences.imagery.WMSSettingsPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public final class ImageryPreference
extends ExtensibleTabPreferenceSetting {
    private ImageryProvidersPanel imageryProviders;
    private ImageryLayerInfo layerInfo;
    private final CommonSettingsPanel commonSettings = new CommonSettingsPanel();
    private final WMSSettingsPanel wmsSettings = new WMSSettingsPanel();
    private final TMSSettingsPanel tmsSettings = new TMSSettingsPanel();
    private final CacheSettingsPanel cacheSettingsPanel = new CacheSettingsPanel();

    private ImageryPreference() {
        super("imagery", I18n.tr("Imagery", new Object[0]), I18n.tr("Modify list of imagery layers displayed in the Imagery menu", new Object[0]), false);
    }

    private static void addSettingsSection(JPanel p, String name, JPanel section) {
        ImageryPreference.addSettingsSection(p, name, section, GBC.eol());
    }

    private static void addSettingsSection(JPanel p, String name, JPanel section, GBC gbc) {
        JLabel lbl = new JLabel(name);
        lbl.setFont(lbl.getFont().deriveFont(1));
        lbl.setLabelFor(section);
        p.add((Component)lbl, GBC.std());
        p.add((Component)new JSeparator(), GBC.eol().fill(2).insets(5, 0, 0, 0));
        p.add((Component)section, gbc.insets(20, 5, 0, 10));
    }

    private Component buildSettingsPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ImageryPreference.addSettingsSection(p, I18n.tr("Common Settings", new Object[0]), this.commonSettings);
        ImageryPreference.addSettingsSection(p, I18n.tr("WMS Settings", new Object[0]), this.wmsSettings, GBC.eol().fill(2));
        ImageryPreference.addSettingsSection(p, I18n.tr("TMS Settings", new Object[0]), this.tmsSettings, GBC.eol().fill(2));
        p.add((Component)new JPanel(), GBC.eol().fill(1));
        JScrollPane scrollPane = new JScrollPane(p);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return GuiHelper.setDefaultIncrement(scrollPane);
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        JTabbedPane pane = this.getTabPane();
        this.layerInfo = new ImageryLayerInfo(ImageryLayerInfo.instance);
        this.imageryProviders = new ImageryProvidersPanel(gui, this.layerInfo);
        pane.addTab(I18n.tr("Imagery providers", new Object[0]), this.imageryProviders);
        pane.addTab(I18n.tr("Settings", new Object[0]), this.buildSettingsPanel());
        pane.addTab(I18n.tr("Offset bookmarks", new Object[0]), new OffsetBookmarksPanel(gui));
        pane.addTab(I18n.tr("Cache", new Object[0]), this.cacheSettingsPanel);
        this.loadSettings();
        super.addGui(gui);
    }

    public ImageryProvidersPanel getProvidersPanel() {
        return this.imageryProviders;
    }

    private void loadSettings() {
        this.commonSettings.loadSettings();
        this.wmsSettings.loadSettings();
        this.tmsSettings.loadSettings();
        this.cacheSettingsPanel.loadSettings();
    }

    @Override
    public boolean ok() {
        this.layerInfo.save();
        ImageryLayerInfo.instance.clear();
        ImageryLayerInfo.instance.load(false);
        MainApplication.getMenu().imageryMenu.refreshOffsetMenu();
        OffsetBookmark.saveBookmarks();
        if (!GraphicsEnvironment.isHeadless()) {
            DownloadDialog.getInstance().refreshTileSources();
        }
        boolean commonRestartRequired = this.commonSettings.saveSettings();
        boolean wmsRestartRequired = this.wmsSettings.saveSettings();
        boolean tmsRestartRequired = this.tmsSettings.saveSettings();
        boolean cacheRestartRequired = this.cacheSettingsPanel.saveSettings();
        return commonRestartRequired || wmsRestartRequired || tmsRestartRequired || cacheRestartRequired;
    }

    public void setServerUrl(String server, String url) {
        for (int i = 0; i < this.imageryProviders.activeModel.getRowCount(); ++i) {
            if (!server.equals(this.imageryProviders.activeModel.getValueAt(i, 0).toString())) continue;
            this.imageryProviders.activeModel.setValueAt(url, i, 1);
            return;
        }
        this.imageryProviders.activeModel.addRow(new String[]{server, url});
    }

    public String getServerUrl(String server) {
        for (int i = 0; i < this.imageryProviders.activeModel.getRowCount(); ++i) {
            if (!server.equals(this.imageryProviders.activeModel.getValueAt(i, 0).toString())) continue;
            return this.imageryProviders.activeModel.getValueAt(i, 1).toString();
        }
        return null;
    }

    public static void initialize() {
        ImageryLayerInfo.instance.load(false);
        OffsetBookmark.loadBookmarks();
        MainApplication.getMenu().imageryMenu.refreshImageryMenu();
        MainApplication.getMenu().imageryMenu.refreshOffsetMenu();
    }

    @Override
    public String getHelpContext() {
        return HelpUtil.ht("/Preferences/Imagery");
    }

    static class OffsetBookmarksPanel
    extends JPanel {
        private final OffsetsBookmarksModel model = new OffsetsBookmarksModel();

        OffsetBookmarksPanel(PreferenceTabbedPane gui) {
            super(new GridBagLayout());
            JTable list = new JTable(this.model){

                @Override
                public String getToolTipText(MouseEvent e) {
                    Point p = e.getPoint();
                    return model.getValueAt(this.rowAtPoint(p), this.columnAtPoint(p)).toString();
                }
            };
            TableHelper.setFont(list, this.getClass());
            JScrollPane scroll = new JScrollPane(list);
            this.add((Component)scroll, GBC.eol().fill(1));
            scroll.setPreferredSize(new Dimension(200, 200));
            TableColumnModel mod = list.getColumnModel();
            mod.getColumn(0).setPreferredWidth(150);
            mod.getColumn(1).setPreferredWidth(200);
            mod.getColumn(2).setPreferredWidth(300);
            mod.getColumn(3).setPreferredWidth(150);
            mod.getColumn(4).setPreferredWidth(150);
            JPanel buttonPanel = new JPanel(new FlowLayout());
            JButton add = new JButton(I18n.tr("Add", new Object[0]), ImageProvider.get("dialogs/add", ImageProvider.ImageSizes.SMALLICON));
            buttonPanel.add((Component)add, GBC.std().insets(0, 5, 0, 0));
            add.addActionListener(e -> this.model.addRow(new OffsetBookmark(ProjectionRegistry.getProjection().toCode(), "", "", "", 0.0, 0.0)));
            JButton delete = new JButton(I18n.tr("Delete", new Object[0]), ImageProvider.get("dialogs/delete", ImageProvider.ImageSizes.SMALLICON));
            buttonPanel.add((Component)delete, GBC.std().insets(0, 5, 0, 0));
            delete.addActionListener(e -> {
                if (list.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog(gui, I18n.tr("Please select the row to delete.", new Object[0]));
                } else {
                    int i;
                    while ((i = list.getSelectedRow()) != -1) {
                        this.model.removeRow(i);
                    }
                }
            });
            this.add((Component)buttonPanel, GBC.eol());
        }

        private static class OffsetsBookmarksModel
        extends DefaultTableModel {
            OffsetsBookmarksModel() {
                this.setColumnIdentifiers(new String[]{I18n.tr("Projection", new Object[0]), I18n.tr("Layer", new Object[0]), I18n.tr("Name", new Object[0]), I18n.tr("Easting", new Object[0]), I18n.tr("Northing", new Object[0])});
            }

            private static OffsetBookmark getRow(int row) {
                return OffsetBookmark.getBookmarkByIndex(row);
            }

            private void addRow(OffsetBookmark i) {
                OffsetBookmark.addBookmark(i);
                int p = this.getRowCount() - 1;
                this.fireTableRowsInserted(p, p);
            }

            @Override
            public void removeRow(int i) {
                OffsetBookmark.removeBookmark(OffsetsBookmarksModel.getRow(i));
                this.fireTableRowsDeleted(i, i);
            }

            @Override
            public int getRowCount() {
                return OffsetBookmark.getBookmarksSize();
            }

            @Override
            public Object getValueAt(int row, int column) {
                OffsetBookmark info = OffsetBookmark.getBookmarkByIndex(row);
                switch (column) {
                    case 0: {
                        if (info.getProjectionCode() == null) {
                            return "";
                        }
                        return info.getProjectionCode();
                    }
                    case 1: {
                        return info.getImageryName();
                    }
                    case 2: {
                        return info.getName();
                    }
                    case 3: {
                        return info.getDisplacement().east();
                    }
                    case 4: {
                        return info.getDisplacement().north();
                    }
                }
                throw new ArrayIndexOutOfBoundsException(column);
            }

            @Override
            public void setValueAt(Object o, int row, int column) {
                OffsetBookmark info = OffsetBookmark.getBookmarkByIndex(row);
                switch (column) {
                    case 1: {
                        String name = o.toString();
                        info.setImageryName(name);
                        List layers = ImageryLayerInfo.instance.getLayers().stream().filter(l -> Objects.equals(name, l.getName())).collect(Collectors.toList());
                        if (layers.size() == 1) {
                            info.setImageryId(((ImageryInfo)layers.get(0)).getId());
                            break;
                        }
                        Logging.warn("Not a single layer for the name '" + info.getImageryName() + "': " + String.valueOf(layers));
                        break;
                    }
                    case 2: {
                        info.setName(o.toString());
                        break;
                    }
                    case 3: {
                        double dx = Double.parseDouble((String)o);
                        info.setDisplacement(new EastNorth(dx, info.getDisplacement().north()));
                        break;
                    }
                    case 4: {
                        double dy = Double.parseDouble((String)o);
                        info.setDisplacement(new EastNorth(info.getDisplacement().east(), dy));
                        break;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException(column);
                    }
                }
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column >= 1;
            }
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ImageryPreference();
        }
    }
}

