/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.AbstractMergePanel;
import org.openstreetmap.josm.gui.conflict.pair.IConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.MergedTableCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.tags.MineTableCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeTableCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.tags.TheirTableCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagTableColumnModelBuilder;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TagMerger
extends AbstractMergePanel
implements IConflictResolver {
    private static final String[] KEY_VALUE = new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])};
    private final TagMergeModel model = new TagMergeModel();
    private final JTable mineTable = this.generateTable(new MineTableCellRenderer());
    private final JTable mergedTable = this.generateTable(new MergedTableCellRenderer());
    private final JTable theirTable = this.generateTable(new TheirTableCellRenderer());

    public TagMerger() {
        this.mineTable.setName("table.my");
        this.theirTable.setName("table.their");
        this.mergedTable.setName("table.merged");
        DoubleClickAdapter dblClickAdapter = new DoubleClickAdapter();
        this.mineTable.addMouseListener(dblClickAdapter);
        this.theirTable.addMouseListener(dblClickAdapter);
        this.buildRows();
    }

    private JTable generateTable(TagMergeTableCellRenderer renderer) {
        return new JTable(this.model, new TagTableColumnModelBuilder(renderer, KEY_VALUE).build());
    }

    @Override
    protected List<? extends AbstractMergePanel.MergeRow> getRows() {
        return Arrays.asList(new AbstractMergePanel.TitleRow(), new TagTableRow(), new UndecidedRow());
    }

    public TagMergeModel getModel() {
        return this.model;
    }

    private void selectNextConflict(int ... rows) {
        int max = rows[0];
        for (int row : rows) {
            if (row <= max) continue;
            max = row;
        }
        int index = this.model.getFirstUndecided(max + 1);
        if (index == -1) {
            index = this.model.getFirstUndecided(0);
        }
        this.mineTable.getSelectionModel().setSelectionInterval(index, index);
        this.theirTable.getSelectionModel().setSelectionInterval(index, index);
    }

    @Override
    public void deletePrimitive(boolean deleted) {
        MergeDecisionType decision = deleted ? MergeDecisionType.KEEP_MINE : MergeDecisionType.UNDECIDED;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            this.model.decide(i, decision);
        }
    }

    @Override
    public void populate(Conflict<? extends OsmPrimitive> conflict) {
        this.model.populate(conflict.getMy(), conflict.getTheir());
        for (JTable table : new JTable[]{this.mineTable, this.theirTable}) {
            int index = table.getRowCount() > 0 ? 0 : -1;
            table.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    @Override
    public void decideRemaining(MergeDecisionType decision) {
        this.model.decideRemaining(decision);
    }

    class UndecideAction
    extends AbstractAction
    implements ListSelectionListener {
        UndecideAction() {
            new ImageProvider("dialogs/conflict", "tagundecide").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Mark the selected tags as undecided", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int[] rows = TagMerger.this.mergedTable.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            TagMerger.this.model.decide(rows, MergeDecisionType.UNDECIDED);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(TagMerger.this.mergedTable.getSelectedRowCount() > 0);
        }
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MergeDecisionType mergeDecision;
            JTable table;
            if (e.getClickCount() != 2) {
                return;
            }
            if (e.getSource() == TagMerger.this.mineTable) {
                table = TagMerger.this.mineTable;
                mergeDecision = MergeDecisionType.KEEP_MINE;
            } else if (e.getSource() == TagMerger.this.theirTable) {
                table = TagMerger.this.theirTable;
                mergeDecision = MergeDecisionType.KEEP_THEIR;
            } else if (e.getSource() == TagMerger.this.mergedTable) {
                table = TagMerger.this.mergedTable;
                mergeDecision = MergeDecisionType.UNDECIDED;
            } else {
                return;
            }
            int row = table.rowAtPoint(e.getPoint());
            TagMerger.this.model.decide(row, mergeDecision);
        }
    }

    static class AdjustmentSynchronizer
    implements AdjustmentListener {
        private final Set<Adjustable> synchronizedAdjustables = new HashSet<Adjustable>();

        AdjustmentSynchronizer() {
        }

        public void synchronizeAdjustment(Adjustable adjustable) {
            if (adjustable == null) {
                return;
            }
            if (this.synchronizedAdjustables.contains(adjustable)) {
                return;
            }
            this.synchronizedAdjustables.add(adjustable);
            adjustable.addAdjustmentListener(this);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            for (Adjustable a : this.synchronizedAdjustables) {
                if (a == e.getAdjustable()) continue;
                a.setValue(e.getValue());
            }
        }
    }

    class KeepTheirAction
    extends AbstractAction
    implements ListSelectionListener {
        KeepTheirAction() {
            new ImageProvider("dialogs/conflict", "tagkeeptheir").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Keep the selected key/value pairs from the server dataset", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int[] rows = TagMerger.this.theirTable.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            TagMerger.this.model.decide(rows, MergeDecisionType.KEEP_THEIR);
            TagMerger.this.selectNextConflict(rows);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(TagMerger.this.theirTable.getSelectedRowCount() > 0);
        }
    }

    class KeepMineAction
    extends AbstractAction
    implements ListSelectionListener {
        KeepMineAction() {
            new ImageProvider("dialogs/conflict", "tagkeepmine").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Keep the selected key/value pairs from the local dataset", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int[] rows = TagMerger.this.mineTable.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            TagMerger.this.model.decide(rows, MergeDecisionType.KEEP_MINE);
            TagMerger.this.selectNextConflict(rows);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(TagMerger.this.mineTable.getSelectedRowCount() > 0);
        }
    }

    private final class UndecidedRow
    extends AbstractMergePanel.AbstractUndecideRow {
        private UndecidedRow() {
        }

        @Override
        protected AbstractAction createAction() {
            UndecideAction undecidedAction = new UndecideAction();
            TagMerger.this.mergedTable.getSelectionModel().addListSelectionListener(undecidedAction);
            return undecidedAction;
        }

        @Override
        protected String getButtonName() {
            return "button.undecide";
        }
    }

    private final class TagTableRow
    extends AbstractMergePanel.MergeRow {
        private final AdjustmentSynchronizer adjustmentSynchronizer = new AdjustmentSynchronizer();

        private TagTableRow() {
        }

        JScrollPane embeddInScrollPane(JTable table) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)table.getTableHeader(), GBC.eol().fill(2));
            panel.add((Component)table, GBC.eol().fill(1));
            JScrollPane pane = GuiHelper.embedInVerticalScrollPane(panel);
            this.adjustmentSynchronizer.synchronizeAdjustment(pane.getVerticalScrollBar());
            return pane;
        }

        @Override
        protected JComponent mineField() {
            return this.embeddInScrollPane(TagMerger.this.mineTable);
        }

        @Override
        protected JComponent mineButton() {
            KeepMineAction keepMineAction = new KeepMineAction();
            TagMerger.this.mineTable.getSelectionModel().addListSelectionListener(keepMineAction);
            JButton btnKeepMine = new JButton(keepMineAction);
            btnKeepMine.setName("button.keepmine");
            return btnKeepMine;
        }

        @Override
        protected JComponent merged() {
            return this.embeddInScrollPane(TagMerger.this.mergedTable);
        }

        @Override
        protected JComponent theirsButton() {
            KeepTheirAction keepTheirAction = new KeepTheirAction();
            TagMerger.this.theirTable.getSelectionModel().addListSelectionListener(keepTheirAction);
            JButton btnKeepTheir = new JButton(keepTheirAction);
            btnKeepTheir.setName("button.keeptheir");
            return btnKeepTheir;
        }

        @Override
        protected JComponent theirsField() {
            return this.embeddInScrollPane(TagMerger.this.theirTable);
        }

        @Override
        protected void addConstraints(GBC constraints, int columnIndex) {
            super.addConstraints(constraints, columnIndex);
            constraints.weighty = 1.0;
        }
    }
}

