/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import java.awt.geom.Area;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Objects;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.Coordinate;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.tools.Utils;

public class LatLon
extends Coordinate
implements ILatLon {
    private static final long serialVersionUID = 1L;
    public static final double MAX_SERVER_PRECISION = 1.0E-7;
    public static final double MAX_SERVER_INV_PRECISION = 1.0E7;
    public static final LatLon ZERO = new LatLon(0.0, 0.0);
    public static final LatLon NORTH_POLE = new LatLon(90.0, 0.0);
    public static final LatLon SOUTH_POLE = new LatLon(-90.0, 0.0);
    public static final DecimalFormat cDdFormatter = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
    public static final DecimalFormat cDdHighPrecisionFormatter;

    public static boolean isValidLat(double lat) {
        return lat >= -90.0 && lat <= 90.0;
    }

    public static boolean isValidLon(double lon) {
        return lon >= -180.0 && lon <= 180.0;
    }

    public static double normalizeLon(double lon) {
        if (lon >= -180.0 && lon <= 180.0) {
            return lon;
        }
        if ((lon %= 360.0) > 180.0) {
            return lon - 360.0;
        }
        if (lon < -180.0) {
            return lon + 360.0;
        }
        return lon;
    }

    public boolean isValid() {
        return LatLon.isValidLat(this.lat()) && LatLon.isValidLon(this.lon());
    }

    public static double toIntervalLat(double value) {
        return Utils.clamp(value, -90.0, 90.0);
    }

    public static double toIntervalLon(double value) {
        if (LatLon.isValidLon(value)) {
            return value;
        }
        int n = (int)(value + Math.signum(value) * 180.0) / 360;
        return value - (double)n * 360.0;
    }

    public LatLon(double lat, double lon) {
        super(lon, lat);
    }

    public LatLon(ILatLon coor) {
        super(coor.lon(), coor.lat());
    }

    @Override
    public double lat() {
        return this.y;
    }

    @Override
    public double lon() {
        return this.x;
    }

    public boolean isWithin(Bounds b) {
        return b.contains(this);
    }

    public boolean isIn(Area a) {
        return a == null || a.contains(this.x, this.y);
    }

    public String toDisplayString() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(5);
        return "lat=" + nf.format(this.lat()) + "\u00b0, lon=" + nf.format(this.lon()) + "\u00b0";
    }

    public LatLon interpolate(LatLon ll2, double proportion) {
        ILatLon interpolated = ILatLon.super.interpolate(ll2, proportion);
        if (interpolated instanceof LatLon) {
            return (LatLon)interpolated;
        }
        return new LatLon(interpolated);
    }

    public LatLon getCenter(LatLon ll2) {
        return this.interpolate(ll2, 0.5);
    }

    public double distance(LatLon ll) {
        return super.distance(ll);
    }

    public double distanceSq(LatLon ll) {
        return super.distanceSq(ll);
    }

    public String toString() {
        return "LatLon[lat=" + this.lat() + ",lon=" + this.lon() + "]";
    }

    public static double roundToOsmPrecision(double value) {
        return (double)Math.round(value * 1.0E7) / 1.0E7;
    }

    public LatLon getRoundedToOsmPrecision() {
        return new LatLon(LatLon.roundToOsmPrecision(this.lat()), LatLon.roundToOsmPrecision(this.lon()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LatLon that = (LatLon)obj;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0;
    }

    static {
        cDdFormatter.applyPattern("###0.0######");
        cDdHighPrecisionFormatter = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
        cDdHighPrecisionFormatter.applyPattern("###0.0##########");
    }
}

