/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.openstreetmap.josm.actions.AbstractUploadAction;
import org.openstreetmap.josm.actions.upload.ApiPreconditionCheckerHook;
import org.openstreetmap.josm.actions.upload.DiscardTagsHook;
import org.openstreetmap.josm.actions.upload.FixDataHook;
import org.openstreetmap.josm.actions.upload.RelationUploadOrderHook;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.actions.upload.ValidateUploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.AsynchronousUploadPrimitivesTask;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.io.UploadPrimitivesTask;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.ChangesetUpdater;
import org.openstreetmap.josm.io.UploadStrategySpecification;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class UploadAction
extends AbstractUploadAction {
    private static final List<UploadHook> UPLOAD_HOOKS = new LinkedList<UploadHook>();
    private static final List<UploadHook> LATE_UPLOAD_HOOKS = new LinkedList<UploadHook>();
    private static final String IS_ASYNC_UPLOAD_ENABLED = "asynchronous.upload";

    public static void registerUploadHook(UploadHook hook) {
        UploadAction.registerUploadHook(hook, false);
    }

    public static void registerUploadHook(UploadHook hook, boolean late) {
        if (hook == null) {
            return;
        }
        if (late) {
            if (!LATE_UPLOAD_HOOKS.contains(hook)) {
                LATE_UPLOAD_HOOKS.add(0, hook);
            }
        } else if (!UPLOAD_HOOKS.contains(hook)) {
            UPLOAD_HOOKS.add(0, hook);
        }
    }

    public static void unregisterUploadHook(UploadHook hook) {
        if (hook == null) {
            return;
        }
        UPLOAD_HOOKS.remove(hook);
        LATE_UPLOAD_HOOKS.remove(hook);
    }

    public UploadAction() {
        super(I18n.tr("Upload data...", new Object[0]), "upload", I18n.tr("Upload all changes in the active data layer to the OSM server", new Object[0]), Shortcut.registerShortcut("file:upload", I18n.tr("File: {0}", I18n.tr("Upload data", new Object[0])), 38, 5009), true);
        this.setHelpId(HelpUtil.ht("/Action/Upload"));
    }

    @Override
    protected boolean listenToSelectionChange() {
        return false;
    }

    @Override
    protected void updateEnabledState() {
        OsmDataLayer editLayer = this.getLayerManager().getEditLayer();
        this.setEnabled(editLayer != null && editLayer.requiresUploadToServer());
    }

    public static boolean checkPreUploadConditions(AbstractModifiableLayer layer) {
        return UploadAction.checkPreUploadConditions(layer, layer instanceof OsmDataLayer ? new APIDataSet(((OsmDataLayer)layer).getDataSet()) : null);
    }

    protected static void alertUnresolvedConflicts(OsmDataLayer layer) {
        HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), I18n.tr("<html>The data to be uploaded participates in unresolved conflicts of layer ''{0}''.<br>You have to resolve them first.</html>", Utils.escapeReservedCharactersHTML(layer.getName())), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Action/Upload#PrimitivesParticipateInConflicts"));
    }

    public static boolean warnUploadDiscouraged(AbstractModifiableLayer layer) {
        return GuiHelper.warnUser(I18n.tr("Upload discouraged", new Object[0]), "<html>" + I18n.tr("You are about to upload data from the layer ''{0}''.<br /><br />Sending data from this layer is <b>strongly discouraged</b>. If you continue,<br />it may require you subsequently have to revert your changes, or force other contributors to.<br /><br />Are you sure you want to continue?", Utils.escapeReservedCharactersHTML(layer.getName())) + "</html>", ImageProvider.get("upload"), I18n.tr("Ignore this hint and upload anyway", new Object[0]));
    }

    public static boolean checkPreUploadConditions(AbstractModifiableLayer layer, APIDataSet apiData) {
        try {
            return UploadAction.checkPreUploadConditionsAsync(layer, apiData, null).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JosmRuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new JosmRuntimeException(e);
        }
    }

    private static Future<Boolean> checkPreUploadConditionsAsync(AbstractModifiableLayer layer, APIDataSet apiData, Consumer<Boolean> onFinish) {
        OsmDataLayer osmLayer;
        ConflictCollection conflicts;
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        if (onFinish != null) {
            future.thenAccept((Consumer)onFinish);
        }
        if (layer.isUploadDiscouraged() && UploadAction.warnUploadDiscouraged(layer)) {
            future.complete(false);
        } else if (layer instanceof OsmDataLayer && apiData.participatesInConflict(conflicts = (osmLayer = (OsmDataLayer)layer).getConflicts())) {
            UploadAction.alertUnresolvedConflicts(osmLayer);
            future.complete(false);
        }
        if (!future.isDone()) {
            MainApplication.worker.execute(() -> {
                boolean hooks = true;
                if (apiData != null) {
                    hooks = UPLOAD_HOOKS.stream().allMatch(hook -> hook.checkUpload(apiData));
                }
                future.complete(hooks);
            });
        }
        return future;
    }

    public void uploadData(OsmDataLayer layer, APIDataSet apiData) {
        if (apiData.isEmpty()) {
            new Notification(I18n.tr("No changes to upload.", new Object[0])).setIcon(1).show();
            return;
        }
        UploadAction.checkPreUploadConditionsAsync(layer, apiData, passed -> GuiHelper.runInEDT(() -> {
            if (Boolean.TRUE.equals(passed)) {
                UploadAction.realUploadData(layer, apiData);
            } else {
                new Notification(I18n.tr("One of the upload verification processes failed", new Object[0])).setIcon(2).show();
            }
        }));
    }

    private static void realUploadData(OsmDataLayer layer, APIDataSet apiData) {
        ChangesetUpdater.check();
        UploadDialog dialog = UploadDialog.getUploadDialog();
        dialog.setUploadedPrimitives(apiData);
        dialog.initLifeCycle(layer.getDataSet());
        Map<String, String> changesetTags = dialog.getChangeset().getKeys();
        HashMap<String, String> originalChangesetTags = new HashMap<String, String>(changesetTags);
        for (UploadHook uploadHook : UPLOAD_HOOKS) {
            uploadHook.modifyChangesetTags(changesetTags);
        }
        dialog.getModel().putAll(changesetTags);
        if (!originalChangesetTags.equals(changesetTags)) {
            dialog.setChangesetTagsModifiedProgramatically();
        }
        dialog.setVisible(true);
        dialog.rememberUserInput();
        if (dialog.isCanceled()) {
            dialog.clean();
            return;
        }
        for (UploadHook uploadHook : LATE_UPLOAD_HOOKS) {
            if (uploadHook.checkUpload(apiData)) continue;
            dialog.clean();
            return;
        }
        Changeset cs = dialog.getChangeset();
        changesetTags = cs.getKeys();
        for (UploadHook hook : LATE_UPLOAD_HOOKS) {
            hook.modifyChangesetTags(changesetTags);
        }
        UploadStrategySpecification uploadStrategySpecification = dialog.getUploadStrategySpecification();
        Logging.info("Starting upload with tags {0}", changesetTags);
        Logging.info(uploadStrategySpecification.toString());
        Logging.info(cs.toString());
        dialog.clean();
        if (Config.getPref().getBoolean(IS_ASYNC_UPLOAD_ENABLED, true)) {
            Optional<AsynchronousUploadPrimitivesTask> asyncUploadTask = AsynchronousUploadPrimitivesTask.createAsynchronousUploadTask(uploadStrategySpecification, layer, apiData, cs);
            asyncUploadTask.ifPresent(MainApplication.worker::execute);
        } else {
            MainApplication.worker.execute(new UploadPrimitivesTask(uploadStrategySpecification, layer, apiData, cs));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (MainApplication.getMap() == null) {
            new Notification(I18n.tr("Nothing to upload. Get some data first.", new Object[0])).setIcon(1).show();
            return;
        }
        APIDataSet apiData = new APIDataSet(this.getLayerManager().getEditDataSet());
        this.uploadData(this.getLayerManager().getEditLayer(), apiData);
    }

    static {
        UPLOAD_HOOKS.add(new ValidateUploadHook());
        UPLOAD_HOOKS.add(new FixDataHook());
        UPLOAD_HOOKS.add(new ApiPreconditionCheckerHook());
        UPLOAD_HOOKS.add(new RelationUploadOrderHook());
        LATE_UPLOAD_HOOKS.add(new DiscardTagsHook());
    }
}

