/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.log;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.MessageFormatter;

public class JulLogAdapter
implements Log {
    private final Logger logger;

    public JulLogAdapter(Logger logger) {
        this.logger = logger;
    }

    private void log(Level level, String message) {
        if (this.logger.isLoggable(level)) {
            this.logger.logp(level, this.logger.getName(), "", message);
        }
    }

    private void log(Level level, Object message) {
        if (this.logger.isLoggable(level)) {
            if (message instanceof Throwable) {
                this.logger.logp(level, this.logger.getName(), "", "Exception:", (Throwable)message);
            } else {
                this.logger.logp(level, this.logger.getName(), "", message == null ? null : message.toString());
            }
        }
    }

    private void log(Level level, String message, Throwable t) {
        if (this.logger.isLoggable(level)) {
            this.logger.logp(level, this.logger.getName(), "", message, t);
        }
    }

    private void log(Level level, String message, Object ... params) {
        if (this.logger.isLoggable(level)) {
            MessageFormatter formatter = new MessageFormatter(message, params);
            if (formatter.hasThrowable()) {
                this.logger.logp(level, this.logger.getName(), "", formatter.getFormattedMessage(), formatter.getThrowable());
            } else {
                this.logger.logp(level, this.logger.getName(), "", formatter.getFormattedMessage());
            }
        }
    }

    private void log(Level level, String message, Supplier<?> ... paramSuppliers) {
        if (this.logger.isLoggable(level)) {
            MessageFormatter formatter = new MessageFormatter(message, paramSuppliers);
            if (formatter.hasThrowable()) {
                this.logger.logp(level, this.logger.getName(), "", formatter.getFormattedMessage(), formatter.getThrowable());
            } else {
                this.logger.logp(level, this.logger.getName(), "", formatter.getFormattedMessage());
            }
        }
    }

    @Override
    public void debug(String message) {
        this.log(Level.FINE, message);
    }

    @Override
    public void debug(Object message) {
        this.log(Level.FINE, message);
    }

    @Override
    public void debug(String message, Object ... params) {
        this.log(Level.FINE, message, params);
    }

    @Override
    public void debug(String message, Supplier<?> ... paramSuppliers) {
        this.log(Level.FINE, message, paramSuppliers);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    @Override
    public void error(String message) {
        this.log(Level.SEVERE, message);
    }

    @Override
    public void error(Object message) {
        this.log(Level.SEVERE, message);
    }

    @Override
    public void error(String message, Object ... params) {
        this.log(Level.SEVERE, message, params);
    }

    @Override
    public void error(String message, Supplier<?> ... paramSuppliers) {
        this.log(Level.SEVERE, message, paramSuppliers);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    @Override
    public void fatal(String message) {
        this.log(Level.SEVERE, message);
    }

    @Override
    public void fatal(Object message) {
        this.log(Level.SEVERE, message);
    }

    @Override
    public void fatal(String message, Object ... params) {
        this.log(Level.SEVERE, message, params);
    }

    @Override
    public void fatal(String message, Supplier<?> ... paramSuppliers) {
        this.log(Level.SEVERE, message, paramSuppliers);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void info(String message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void info(Object message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void info(String message, Object ... params) {
        this.log(Level.INFO, message, params);
    }

    @Override
    public void info(String message, Supplier<?> ... paramSuppliers) {
        this.log(Level.INFO, message, paramSuppliers);
    }

    @Override
    public void info(String message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void trace(String message) {
        this.log(Level.FINER, message);
    }

    @Override
    public void trace(Object message) {
        this.log(Level.FINER, message);
    }

    @Override
    public void trace(String message, Object ... params) {
        this.log(Level.FINER, message, params);
    }

    @Override
    public void trace(String message, Supplier<?> ... paramSuppliers) {
        this.log(Level.FINER, message, paramSuppliers);
    }

    @Override
    public void trace(String message, Throwable t) {
        this.log(Level.FINER, message, t);
    }

    @Override
    public void warn(String message) {
        this.log(Level.WARNING, message);
    }

    @Override
    public void warn(Object message) {
        this.log(Level.WARNING, message);
    }

    @Override
    public void warn(String message, Object ... params) {
        this.log(Level.WARNING, message, params);
    }

    @Override
    public void warn(String message, Supplier<?> ... paramSuppliers) {
        this.log(Level.WARNING, message, paramSuppliers);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }
}

