from __future__ import annotations

from gi.repository import GObject

import os
from typing import Optional
from urllib.parse import quote


class Attachment(GObject.Object):
    """A note attachment."""

    def __init__(self) -> None:
        super().__init__()
        self.__note_id = -1
        self.__note_remote_id: Optional[int] = None
        self.__path = ""

    @GObject.Property(type=int, default=-1)
    def note_id(self) -> int:
        return self.__note_id

    @note_id.setter
    def set_note_id(self, value: int) -> None:
        self.__note_id = value

    @GObject.Property(type=int, default=-1)
    def note_remote_id(self) -> Optional[int]:
        return self.__note_remote_id

    @note_remote_id.setter
    def set_note_remote_id(self, value: int) -> None:
        self.__note_remote_id = value

    @GObject.Property(type=str, default="")
    def filename(self) -> str:
        return os.path.basename(self.__path)

    @GObject.Property(type=str, default="")
    def path(self) -> str:
        return self.__path

    @path.setter
    def set_path(self, value: str) -> None:
        self.__path = value

    @GObject.Property(type=str, default="")
    def path_quoted(self) -> str:
        return quote(self.path)

    def duplicate(self) -> Attachment:
        """Duplicate attachment.

        Only the shallow fields are copied; the data on disk is not duplicated.

        :return: A copy of the attachment
        :rtype:
        """
        ret = Attachment()
        ret.note_id = self.note_id
        ret.note_remote_id = self.note_remote_id
        ret.path = self.path
        return ret
