/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionActionExtension;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionWithIgnoredFilesConfirmationAction;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionWithIgnoredFilesConfirmationActionKt;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.PairConsumer;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0015\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0015\u0010\u000f\u001a\u00070\u000b\u00a2\u0006\u0002\b\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J4\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001bH\u0002J\u001c\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010$H\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionWithIgnoredFilesConfirmationAction;", "Lcom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction;", "<init>", "()V", "isEnabled", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "", "dialogMessage", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "dialogTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "addPathsToVcs", "project", "Lcom/intellij/openapi/project/Project;", "toAdd", "", "exceptions", "", "Lcom/intellij/openapi/vcs/VcsException;", "containsIgnored", "collectPathsFromChanges", "Lkotlin/sequences/Sequence;", "allChanges", "Lcom/intellij/openapi/vcs/changes/Change;", "collectPathsFromFiles", "allFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "getExtensionFor", "Lcom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionActionExtension;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nScheduleForAdditionWithIgnoredFilesConfirmationAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScheduleForAdditionWithIgnoredFilesConfirmationAction.kt\ncom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionWithIgnoredFilesConfirmationAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,158:1\n3301#2,10:159\n216#3,2:169\n*S KotlinDebug\n*F\n+ 1 ScheduleForAdditionWithIgnoredFilesConfirmationAction.kt\ncom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionWithIgnoredFilesConfirmationAction\n*L\n56#1:159,10\n87#1:169,2\n*E\n"})
public final class ScheduleForAdditionWithIgnoredFilesConfirmationAction
extends ScheduleForAdditionAction {
    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        Project project2 = project;
        if (ScheduleForAdditionAction.Manager.INSTANCE.getUnversionedFiles(e, project2).isNotEmpty()) {
            return true;
        }
        Object[] objectArray = (Change[])e.getData(VcsDataKeys.CHANGES);
        Object object = objectArray != null ? ArraysKt.asSequence((Object[])objectArray) : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        Sequence changes = object;
        Iterable iterable = (Iterable)e.getData(VcsDataKeys.VIRTUAL_FILES);
        Object object2 = iterable != null ? CollectionsKt.asSequence((Iterable)iterable) : null;
        if (object2 == null) {
            object2 = SequencesKt.emptySequence();
        }
        Sequence files = object2;
        return SequencesKt.firstOrNull(this.collectPathsFromChanges(project2, (Sequence<? extends Change>)changes)) != null || SequencesKt.firstOrNull(this.collectPathsFromFiles(project2, (Sequence<? extends VirtualFile>)files)) != null;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        ChangesBrowserBase browser = (ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY);
        Object[] objectArray = (Change[])e.getData(VcsDataKeys.CHANGES);
        Object object = objectArray != null ? ArraysKt.asSequence((Object[])objectArray) : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        Sequence changes = object;
        Iterable iterable = (Iterable)e.getData(VcsDataKeys.VIRTUAL_FILES);
        Object object2 = iterable != null ? CollectionsKt.asSequence((Iterable)iterable) : null;
        if (object2 == null) {
            object2 = SequencesKt.emptySequence();
        }
        Sequence files = object2;
        HashSet toAdd = new HashSet();
        CollectionsKt.addAll((Collection)toAdd, this.collectPathsFromChanges(project2, (Sequence<? extends Change>)changes));
        CollectionsKt.addAll((Collection)toAdd, this.collectPathsFromFiles(project2, (Sequence<? extends VirtualFile>)files));
        List list = ScheduleForAdditionAction.Manager.INSTANCE.getUnversionedFiles(e, project2).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List unversionedFiles = list;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        Iterable $this$partition$iv = toAdd;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            FilePath p0 = (FilePath)element$iv;
            boolean bl = false;
            boolean bl2 = changeListManager2.isIgnoredFile(p0) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List ignored = (List)pair.component1();
        List toAddWithoutIgnored = (List)pair.component2();
        Function1 function1 = (Function1)new Function1<FilePath, String>((Object)this){

            public final String invoke(FilePath p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ScheduleForAdditionWithIgnoredFilesConfirmationAction.access$dialogTitle((ScheduleForAdditionWithIgnoredFilesConfirmationAction)((Object)this.receiver), p0);
            }
        };
        Function1 function12 = (Function1)new Function1<FilePath, String>((Object)this){

            public final String invoke(FilePath p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ScheduleForAdditionWithIgnoredFilesConfirmationAction.access$dialogMessage((ScheduleForAdditionWithIgnoredFilesConfirmationAction)((Object)this.receiver), p0);
            }
        };
        String string = VcsBundle.message((String)"confirmation.title.add.ignored.files.or.dirs", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        List confirmedIgnored2 = ScheduleForAdditionWithIgnoredFilesConfirmationActionKt.access$confirmAddFilePaths(project2, ignored, function1, function12, string);
        PairConsumer addToVcsTask = !((Collection)toAdd).isEmpty() ? (arg_0, arg_1) -> ScheduleForAdditionWithIgnoredFilesConfirmationAction.actionPerformed$lambda$0(this, project2, toAddWithoutIgnored, confirmedIgnored2, arg_0, arg_1) : null;
        ScheduleForAdditionAction.Manager.INSTANCE.performUnversionedFilesAddition$intellij_platform_vcs_impl(project2, unversionedFiles, browser, (PairConsumer<? super ProgressIndicator, ? super List<VcsException>>)addToVcsTask);
    }

    private final String dialogMessage(FilePath path) {
        String string = path.isDirectory() ? VcsBundle.message((String)"confirmation.message.add.ignored.single.directory", (Object[])new Object[0]) : VcsBundle.message((String)"confirmation.message.add.ignored.single.file", (Object[])new Object[0]);
        Intrinsics.checkNotNull((Object)string);
        String question = string;
        return question + "\n" + FileUtil.getLocationRelativeToUserHome((String)path.getPresentableUrl());
    }

    private final String dialogTitle(FilePath path) {
        String string;
        if (path.isDirectory()) {
            String string2 = VcsBundle.message((String)"confirmation.title.add.ignored.single.directory", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = VcsBundle.message((String)"confirmation.title.add.ignored.single.file", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    private final void addPathsToVcs(Project project, Collection<? extends FilePath> toAdd, List<VcsException> exceptions, boolean containsIgnored) {
        Map map = VcsUtil.groupByRoots((Project)project, toAdd, (Function)Functions.identity());
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"groupByRoots(...)");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            VcsRoot vcsRoot = (VcsRoot)entry.getKey();
            List paths = (List)entry.getValue();
            try {
                ScheduleForAdditionActionExtension actionExtension;
                if (this.getExtensionFor(project, vcsRoot.getVcs()) == null) {
                    return;
                }
                VirtualFile virtualFile = vcsRoot.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getPath(...)");
                Intrinsics.checkNotNull((Object)paths);
                actionExtension.doAddFiles(project, virtualFile, paths, containsIgnored);
                VcsFileUtil.markFilesDirty(project, paths);
            }
            catch (VcsException ex) {
                exceptions.add(ex);
            }
        }
    }

    private final Sequence<FilePath> collectPathsFromChanges(Project project, Sequence<? extends Change> allChanges) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.Companion.getInstance(project);
        return SequencesKt.map((Sequence)SequencesKt.filter(allChanges, arg_0 -> ScheduleForAdditionWithIgnoredFilesConfirmationAction.collectPathsFromChanges$lambda$0(this, project, vcsManager, arg_0)), (Function1)collectPathsFromChanges.2.INSTANCE);
    }

    private final Sequence<FilePath> collectPathsFromFiles(Project project, Sequence<? extends VirtualFile> allFiles) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.Companion.getInstance(project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        return SequencesKt.map((Sequence)SequencesKt.filter(allFiles, arg_0 -> ScheduleForAdditionWithIgnoredFilesConfirmationAction.collectPathsFromFiles$lambda$0(this, project, vcsManager, changeListManager2, arg_0)), (Function1)collectPathsFromFiles.2.INSTANCE);
    }

    private final ScheduleForAdditionActionExtension getExtensionFor(Project project, AbstractVcs vcs) {
        return vcs == null ? null : (ScheduleForAdditionActionExtension)ScheduleForAdditionActionExtension.Companion.getEP_NAME().findFirstSafe(arg_0 -> ScheduleForAdditionWithIgnoredFilesConfirmationAction.getExtensionFor$lambda$1(arg_0 -> ScheduleForAdditionWithIgnoredFilesConfirmationAction.getExtensionFor$lambda$0(project, vcs, arg_0), arg_0));
    }

    private static final void actionPerformed$lambda$0(ScheduleForAdditionWithIgnoredFilesConfirmationAction this$0, Project $project, List $toAddWithoutIgnored, List $confirmedIgnored, ProgressIndicator progressIndicator, List exceptions) {
        Collection collection = CollectionsKt.plus((Collection)$toAddWithoutIgnored, (Iterable)$confirmedIgnored);
        Intrinsics.checkNotNull((Object)exceptions);
        this$0.addPathsToVcs($project, collection, exceptions, !((Collection)$confirmedIgnored).isEmpty());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean collectPathsFromChanges$lambda$0(ScheduleForAdditionWithIgnoredFilesConfirmationAction this$0, Project $project, ProjectLevelVcsManager $vcsManager, Change change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        ScheduleForAdditionActionExtension actionExtension = this$0.getExtensionFor($project, $vcsManager.getVcsFor(ChangesUtil.getFilePath((Change)change)));
        if (actionExtension == null) return false;
        FileStatus fileStatus = change.getFileStatus();
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getFileStatus(...)");
        if (!actionExtension.isStatusForAddition(fileStatus)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean collectPathsFromFiles$lambda$0(ScheduleForAdditionWithIgnoredFilesConfirmationAction this$0, Project $project, ProjectLevelVcsManager $vcsManager, ChangeListManager $changeListManager, VirtualFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ScheduleForAdditionActionExtension actionExtension = this$0.getExtensionFor($project, $vcsManager.getVcsFor(file));
        if (actionExtension == null) return false;
        FileStatus status = $changeListManager.getStatus(file);
        boolean bl2 = false;
        if (file.isDirectory()) {
            Intrinsics.checkNotNull((Object)status);
            bl = actionExtension.isStatusForDirectoryAddition(status);
        } else {
            Intrinsics.checkNotNull((Object)status);
            bl = actionExtension.isStatusForAddition(status);
        }
        if (!bl) return false;
        return true;
    }

    private static final boolean getExtensionFor$lambda$0(Project $project, AbstractVcs $vcs, ScheduleForAdditionActionExtension it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getSupportedVcs($project), (Object)$vcs);
    }

    private static final boolean getExtensionFor$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$dialogTitle(ScheduleForAdditionWithIgnoredFilesConfirmationAction $this, FilePath path) {
        return $this.dialogTitle(path);
    }

    public static final /* synthetic */ String access$dialogMessage(ScheduleForAdditionWithIgnoredFilesConfirmationAction $this, FilePath path) {
        return $this.dialogMessage(path);
    }
}

