/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.SemCompatibility;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.UnexpectedVerb;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import java.util.List;
import one.util.streamex.StreamEx;

class Adjectives {
    static final String UNEXPECTED_ADJ_MSG = "An adjective seems to be used instead of a noun";
    static final NodePattern surelyAdj = NodePattern.N.pos("JJ|VBN").noPotentialPos("NN.*|VBG|DT");
    static final NodePattern anAdjectivePattern = surelyAdj.withDependent("det", NodePattern.N.form("an?").markAs("An").beforeHead().and(CommonPatterns.highlightWithTrailingSpace())).noDependents("conj").andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations));
    static final NodePattern adjsMissingNounPosTag = NodePattern.N.lemma("pomodoro|boolean|parenthetical|antivirus|implicit|mock|runnable|disposable|callable|serializable|frontline");

    Adjectives() {
    }

    static NodePattern adjectivePosition() {
        return NodePattern.or(Adjectives.predicativeOnlyAdj(), Adjectives.attributiveOnlyAdj());
    }

    private static NodePattern predicativeOnlyAdj() {
        return NodePattern.N.form(UnexpectedVerb.predicativeOnlyAdjectives.keySet()).beforeHead().markAs("Adj").andOr(NodePattern.N.withHead("amod", NodePattern.N.pos("NNS?").markAs("HeadNoun")), NodePattern.N.form("well").withHead("compound", NodePattern.N.pos("NNS?").markAs("HeadNoun"))).withHead(NodePattern.N.noDependents("amod|compound", NodePattern.N.after("Adj"))).noDependents("xcomp|acl|advcl", NodePattern.N.before("HeadNoun")).andNot(NodePattern.or(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE), NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE.noSpaceAfter()), NodePattern.N.form("a.*").withDependent("compound|advmod|obl:npmod"), NodePattern.N.form("glad").withHead("amod", NodePattern.N.form("tidings*|rags|news|heart|eyes*|hand|things")), NodePattern.N.form("well").withHead("amod|compound", NodePattern.or(NodePattern.N.lemma("woman|girl(friend)?|dudette|lady|princess|man|boy(friend)?|dude|guy|(lord|prince)(ling)?|mind|being"), Semantics.abstractHuman)))).and((node, match) -> {
            List<String> replacements = UnexpectedVerb.predicativeOnlyAdjectives.get(node.lowForm()).stream().filter(s -> SemCompatibility.forSubject(node.copyWithForm((String)s), match.getMarkedNode("HeadNoun")) != SemCompatibility.Unlikely).toList();
            return match.withCorrector(NodeCorrector.replace(node, replacements));
        }).message("The adjective '$_' cannot modify a noun");
    }

    private static NodePattern attributiveOnlyAdj() {
        return Semantics.attributiveOnlyAdj.and(EnglishTreePatterns.adjInPredicativePosition).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE)).andNot(NodePattern.N.withDependent("nmod(:poss)?|det|nummod|acl(:relcl)?|compound|amod|case").noLemma("only")).message("The adjective '$_' cannot be used without a noun");
    }

    static NodePattern unexpectedAdj() {
        NodePattern replaceAdjWithNouns = NodePattern.custom((adj, match) -> {
            List suggestions = Articles.adjsToNouns.get(adj.lowForm());
            if (suggestions == null) {
                suggestions = ((StreamEx)adj.similarWordsOfPos("NN").limit(2L)).toList();
            }
            return match.withCorrector(NodeCorrector.replace(adj, suggestions));
        });
        NodePattern allowAdjAsNominalHead = NodePattern.or(CommonPatterns.capitalizedMiddle, NodePattern.N.form("(inner|outer|northern|southern|eastern|western)most"), NodePattern.N.withDependent("advmod", NodePattern.N.form("most|more|least|less")), NodePattern.N.withDependent("compound", NodePattern.N.noPos()));
        NodePattern anAdjective = anAdjectivePattern.spaceBefore().andOr(NodePattern.N.withDependent("compound", NodePattern.N.potentialPos("CD")), NodePattern.N.withDependent("amod|nummod", NodePattern.N.beforeHead()).noDependents("compound")).noDependents("advmod").andNot(adjsMissingNounPosTag);
        NodePattern detAdjectiveOf = surelyAdj.and(CommonPatterns.letterWord).markAs("Adj").withDependent("det|nmod:poss", NodePattern.N.beforeHead().markAs("Det").and(CommonPatterns.highlightWithTrailingSpace())).andNot(allowAdjAsNominalHead).and(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|root"))).withDependent("nmod|obl", NodePattern.N.afterHead().withDependent("case", NodePattern.N.form("of").directlyAfter("Adj").markAs("Of")));
        NodePattern copNmodPossAdjective = surelyAdj.withDependent("nmod:poss", NodePattern.N.beforeHead().and(CommonPatterns.highlightWithTrailingSpace())).withDependent("cop", NodePattern.N.beforeHead()).noForm("own").andNot(Semantics.adjectivesPossiblyDenotingGroups).noDependents(NodePattern.N.afterHead());
        return NodePattern.or(anAdjective, detAdjectiveOf, copNmodPossAdjective).and(replaceAdjWithNouns).onlyWithSuggestions().includeIntoReport().andNot(adjsMissingNounPosTag).andNot(CommonPatterns.lastToken).message(UNEXPECTED_ADJ_MSG);
    }
}

