/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.testng;

import com.intellij.execution.TestDiscoveryListener;
import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.testng.IDEATestNGListener;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestResult;

public class TestNGTestDiscoveryListener
extends TestDiscoveryListener
implements IDEATestNGListener,
ISuiteListener {
    public void onTestStart(ITestResult result) {
        this.testStarted(result.getTestClass().getName(), result.getTestName());
    }

    public void onTestSuccess(ITestResult result) {
        this.testFinished(result.getTestClass().getName(), result.getName(), true);
    }

    public void onTestFailure(ITestResult result) {
        this.testFinished(result.getTestClass().getName(), result.getName(), ComparisonFailureData.isAssertionError(result.getThrowable().getClass()));
    }

    public void onTestSkipped(ITestResult result) {
        this.testFinished(result.getTestClass().getName(), result.getName(), false);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.testFinished(result.getTestClass().getName(), result.getName(), true);
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    public void onStart(ISuite suite) {
        this.testRunStarted(suite.getName());
    }

    public void onFinish(ISuite suite) {
        this.testRunFinished(suite.getName());
    }

    public String getFrameworkId() {
        return "g";
    }
}

