/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.debug;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.debug.CoroutineInfo;
import kotlinx.coroutines.debug.DebugProbes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u001aP\u0010\u0000\u001a\u0002H\u0001\"\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\b\u0004\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00010\nH\u0080\b\u00a2\u0006\u0002\u0010\r\u001a0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0014*\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002\u00a8\u0006\u0017"}, d2={"runWithTimeoutDumpingCoroutines", "T", "", "methodName", "", "testTimeoutMs", "", "cancelOnTimeout", "", "initCancellationException", "Lkotlin/Function0;", "", "invocation", "(Ljava/lang/String;JZLkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "handleTimeout", "", "testThread", "Ljava/lang/Thread;", "cancellationException", "cancelIfNecessary", "", "attachStacktraceFrom", "thread", "kotlinx-coroutines-debug"})
@SourceDebugExtension(value={"SMAP\nCoroutinesTimeoutImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutinesTimeoutImpl.kt\nkotlinx/coroutines/debug/CoroutinesTimeoutImplKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1#2:79\n1863#3,2:80\n*S KotlinDebug\n*F\n+ 1 CoroutinesTimeoutImpl.kt\nkotlinx/coroutines/debug/CoroutinesTimeoutImplKt\n*L\n68#1:80,2\n*E\n"})
public final class CoroutinesTimeoutImplKt {
    public static final <T> T runWithTimeoutDumpingCoroutines(@NotNull String methodName, long testTimeoutMs, boolean cancelOnTimeout, @NotNull Function0<? extends Throwable> initCancellationException, @NotNull Function0<? extends T> invocation) {
        Thread thread2;
        boolean $i$f$runWithTimeoutDumpingCoroutines = false;
        CountDownLatch testStartedLatch = new CountDownLatch(1);
        FutureTask testResult2 = new FutureTask(new Callable(testStartedLatch, invocation){
            final /* synthetic */ CountDownLatch $testStartedLatch;
            final /* synthetic */ Function0<T> $invocation;
            {
                this.$testStartedLatch = $testStartedLatch;
                this.$invocation = $invocation;
            }

            public final T call() {
                this.$testStartedLatch.countDown();
                return this.$invocation.invoke();
            }
        });
        Thread $this$runWithTimeoutDumpingCoroutines_u24lambda_u240 = thread2 = new Thread((Runnable)testResult2, "Timeout test thread");
        boolean bl = false;
        $this$runWithTimeoutDumpingCoroutines_u24lambda_u240.setDaemon(true);
        Thread testThread = thread2;
        try {
            testThread.start();
            testStartedLatch.await();
            return (T)testResult2.get(testTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            CoroutinesTimeoutImplKt.handleTimeout(testThread, methodName, testTimeoutMs, cancelOnTimeout, initCancellationException.invoke());
            throw new KotlinNothingValueException();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
    }

    private static final Void handleTimeout(Thread testThread, String methodName, long testTimeoutMs, boolean cancelOnTimeout, Throwable cancellationException) {
        String units = testTimeoutMs % (long)1000 == 0L ? testTimeoutMs / (long)1000 + " seconds" : testTimeoutMs + " milliseconds";
        System.err.println("\nTest " + methodName + " timed out after " + units + '\n');
        System.err.flush();
        DebugProbes.dumpCoroutines$default(DebugProbes.INSTANCE, null, 1, null);
        System.out.flush();
        CoroutinesTimeoutImplKt.attachStacktraceFrom(cancellationException, testThread);
        testThread.interrupt();
        CoroutinesTimeoutImplKt.cancelIfNecessary(cancelOnTimeout);
        throw cancellationException;
    }

    private static final void cancelIfNecessary(boolean cancelOnTimeout) {
        if (cancelOnTimeout) {
            Iterable $this$forEach$iv = DebugProbes.INSTANCE.dumpCoroutinesInfo();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CoroutineInfo it = (CoroutineInfo)element$iv;
                boolean bl = false;
                Job job2 = it.getJob();
                if (job2 != null) {
                    Job.DefaultImpls.cancel$default(job2, null, 1, null);
                }
            }
        }
    }

    private static final void attachStacktraceFrom(Throwable $this$attachStacktraceFrom, Thread thread2) {
        StackTraceElement[] stackTrace = thread2.getStackTrace();
        $this$attachStacktraceFrom.setStackTrace(stackTrace);
    }
}

