/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u000b*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/SamTypeApproximator;", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "typeApproximator", "Lorg/jetbrains/kotlin/types/TypeApproximator;", "getSamTypeForValueParameter", "Lorg/jetbrains/kotlin/types/KotlinType;", "valueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "carefulApproximationOfContravariantProjection", "", "removeExternalProjections", "ir.psi2ir"})
@SourceDebugExtension(value={"SMAP\nSamTypeFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SamTypeFactory.kt\norg/jetbrains/kotlin/psi2ir/generators/SamTypeApproximator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1573#2:90\n1604#2,4:91\n*S KotlinDebug\n*F\n+ 1 SamTypeFactory.kt\norg/jetbrains/kotlin/psi2ir/generators/SamTypeApproximator\n*L\n73#1:90\n73#1:91,4\n*E\n"})
public final class SamTypeApproximator {
    @NotNull
    private final TypeApproximator typeApproximator;

    public SamTypeApproximator(@NotNull KotlinBuiltIns builtIns, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.typeApproximator = new TypeApproximator(builtIns, languageVersionSettings);
    }

    @Nullable
    public final KotlinType getSamTypeForValueParameter(@NotNull ValueParameterDescriptor valueParameter, boolean carefulApproximationOfContravariantProjection) {
        KotlinType originalSingleArgumentType;
        KotlinType singleArgumentType;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)valueParameter, (String)"valueParameter");
                singleArgumentType = null;
                originalSingleArgumentType = null;
                KotlinType varargElementType = valueParameter.getVarargElementType();
                if (varargElementType != null) {
                    boolean bl;
                    singleArgumentType = varargElementType;
                    originalSingleArgumentType = valueParameter.getOriginal().getVarargElementType();
                    boolean bl2 = bl = originalSingleArgumentType != null;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-SamTypeApproximator$getSamTypeForValueParameter$22 = false;
                        String $i$a$-assert-SamTypeApproximator$getSamTypeForValueParameter$22 = "Value parameter and original value parameter have inconsistent varargs: " + valueParameter + "; " + valueParameter.getOriginal();
                        throw new AssertionError((Object)$i$a$-assert-SamTypeApproximator$getSamTypeForValueParameter$22);
                    }
                } else {
                    KotlinType kotlinType = valueParameter.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                    singleArgumentType = kotlinType;
                    originalSingleArgumentType = valueParameter.getOriginal().getType();
                }
                if (KotlinTypeKt.isError(singleArgumentType)) break block8;
                KotlinType kotlinType = originalSingleArgumentType;
                Intrinsics.checkNotNull((Object)kotlinType);
                if (!KotlinTypeKt.isError(kotlinType)) break block9;
            }
            return null;
        }
        KotlinType originalTypeToUse = KotlinBuiltIns.isNothing(singleArgumentType) ? TypeUtilsKt.replaceArgumentsWithNothing(originalSingleArgumentType) : singleArgumentType;
        KotlinTypeMarker kotlinTypeMarker = this.typeApproximator.approximateToSubType(originalTypeToUse, (TypeApproximatorConfiguration)TypeApproximatorConfiguration.UpperBoundAwareIntersectionTypeApproximator.INSTANCE);
        if (kotlinTypeMarker == null) {
            kotlinTypeMarker = originalTypeToUse;
        }
        KotlinTypeMarker approximatedOriginalTypeToUse = kotlinTypeMarker;
        Intrinsics.checkNotNull((Object)approximatedOriginalTypeToUse, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.KotlinType");
        KotlinType cfr_ignored_0 = (KotlinType)approximatedOriginalTypeToUse;
        return this.removeExternalProjections((KotlinType)approximatedOriginalTypeToUse, carefulApproximationOfContravariantProjection);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType removeExternalProjections(KotlinType $this$removeExternalProjections, boolean carefulApproximationOfContravariantProjection) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = $this$removeExternalProjections.getArguments();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            TypeProjection typeProjection;
            void argument;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (carefulApproximationOfContravariantProjection && argument.getProjectionKind() == Variance.IN_VARIANCE) {
                TypeParameterDescriptor parameter;
                void i;
                List<TypeParameterDescriptor> list = $this$removeExternalProjections.getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
                if ((TypeParameterDescriptor)CollectionsKt.getOrNull(list, (int)i) == null) {
                    return null;
                }
                List<KotlinType> list2 = parameter.getUpperBounds();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getUpperBounds(...)");
                KotlinType kotlinType = (KotlinType)CollectionsKt.singleOrNull(list2);
                if (kotlinType == null || (kotlinType = FlexibleTypesKt.upperIfFlexible(kotlinType)) == null) {
                    return null;
                }
                KotlinType upperBound = kotlinType;
                if (!TypeUtilsKt.isNullableAny(upperBound)) {
                    return null;
                }
                typeProjection = TypeUtilsKt.asTypeProjection(upperBound);
            } else {
                typeProjection = new TypeProjectionImpl(Variance.INVARIANT, argument.getType());
            }
            collection.add(typeProjection);
        }
        List newArguments2 = (List)destination$iv$iv;
        return TypeSubstitutionKt.replace$default($this$removeExternalProjections, newArguments2, null, null, 6, null);
    }
}

