/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.JvmExpectDeclarationRemover;
import org.jetbrains.kotlin.backend.jvm.lower.JvmInlineCallableReferenceToLambdaWithDefaultsPhase;
import org.jetbrains.kotlin.backend.jvm.lower.JvmInlineFunctionResolver;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.inline.FunctionInlining;
import org.jetbrains.kotlin.ir.inline.InlineFunctionResolver;

@PhaseDescription(name="FunctionInliningPhase", prerequisite={JvmExpectDeclarationRemover.class, JvmInlineCallableReferenceToLambdaWithDefaultsPhase.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0017\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmIrInliner;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "inliner", "Lorg/jetbrains/kotlin/ir/inline/FunctionInlining;", "getInliner$annotations", "()V", "getInliner", "()Lorg/jetbrains/kotlin/ir/inline/FunctionInlining;", "enabled", "", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.jvm.lower"})
public final class JvmIrInliner
implements FileLoweringPass {
    @NotNull
    private final FunctionInlining inliner;
    private final boolean enabled;

    public JvmIrInliner(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JvmInlineFunctionResolver jvmInlineFunctionResolver = new JvmInlineFunctionResolver(context);
        this.inliner = new FunctionInlining((LoweringContext)context, (InlineFunctionResolver)jvmInlineFunctionResolver, false, true, true);
        this.enabled = context.getConfig().getEnableIrInliner();
    }

    @NotNull
    public final FunctionInlining getInliner() {
        return this.inliner;
    }

    public static /* synthetic */ void getInliner$annotations() {
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.enabled) {
            this.inliner.lower(irFile);
        }
    }
}

