/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirThisOwnerSymbol;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007*\u00020\bH\u0002\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\n"}, d2={"areReceiversEquivalent", "", "existingCall", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "candidateCall", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "boundSymbolForReceiverExpression", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "resolvesToSameStaticMethods", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nreferenceShortenerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 referenceShortenerUtils.kt\norg/jetbrains/kotlin/analysis/api/fir/components/ReferenceShortenerUtilsKt\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,75:1\n36#2:76\n*S KotlinDebug\n*F\n+ 1 referenceShortenerUtils.kt\norg/jetbrains/kotlin/analysis/api/fir/components/ReferenceShortenerUtilsKt\n*L\n72#1:76\n*E\n"})
public final class ReferenceShortenerUtilsKt {
    public static final boolean areReceiversEquivalent(@NotNull FirQualifiedAccessExpression existingCall, @NotNull Candidate candidateCall) {
        FirBasedSymbol<?> candidateExtensionSymbol;
        Intrinsics.checkNotNullParameter((Object)existingCall, (String)"existingCall");
        Intrinsics.checkNotNullParameter((Object)candidateCall, (String)"candidateCall");
        FirExpression firExpression = existingCall.getExtensionReceiver();
        FirBasedSymbol<?> existingExtensionSymbol = firExpression != null ? ReferenceShortenerUtilsKt.boundSymbolForReceiverExpression(firExpression) : null;
        FirExpression firExpression2 = candidateCall.chosenExtensionReceiverExpression();
        Object object = candidateExtensionSymbol = firExpression2 != null ? ReferenceShortenerUtilsKt.boundSymbolForReceiverExpression(firExpression2) : null;
        if (!Intrinsics.areEqual(existingExtensionSymbol, candidateExtensionSymbol)) {
            return false;
        }
        if (ReferenceShortenerUtilsKt.resolvesToSameStaticMethods(existingCall, candidateCall)) {
            return true;
        }
        FirExpression firExpression3 = existingCall.getDispatchReceiver();
        FirBasedSymbol<?> existingDispatchReceiver = firExpression3 != null ? ReferenceShortenerUtilsKt.boundSymbolForReceiverExpression(firExpression3) : null;
        FirExpression firExpression4 = candidateCall.dispatchReceiverExpression();
        FirBasedSymbol<?> candidateDispatchReceiver = firExpression4 != null ? ReferenceShortenerUtilsKt.boundSymbolForReceiverExpression(firExpression4) : null;
        return Intrinsics.areEqual(existingDispatchReceiver, candidateDispatchReceiver);
    }

    private static final FirBasedSymbol<?> boundSymbolForReceiverExpression(FirExpression $this$boundSymbolForReceiverExpression) {
        FirBasedSymbol firBasedSymbol;
        FirExpression firExpression = $this$boundSymbolForReceiverExpression;
        if (firExpression instanceof FirThisReceiverExpression) {
            FirThisOwnerSymbol firThisOwnerSymbol = ((FirThisReceiverExpression)$this$boundSymbolForReceiverExpression).getCalleeReference().getBoundSymbol();
            Intrinsics.checkNotNull((Object)firThisOwnerSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.FirBasedSymbol<*>");
            firBasedSymbol = (FirBasedSymbol)firThisOwnerSymbol;
        } else if (firExpression instanceof FirResolvedQualifier) {
            FirClassLikeSymbol firClassLikeSymbol;
            if (((FirResolvedQualifier)$this$boundSymbolForReceiverExpression).getResolvedToCompanionObject()) {
                FirClassLikeSymbol firClassLikeSymbol2 = ((FirResolvedQualifier)$this$boundSymbolForReceiverExpression).getSymbol();
                FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol2 instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol2 : null;
                firClassLikeSymbol = (FirClassLikeSymbol)(firRegularClassSymbol != null ? firRegularClassSymbol.getCompanionObjectSymbol() : null);
            } else {
                firClassLikeSymbol = ((FirResolvedQualifier)$this$boundSymbolForReceiverExpression).getSymbol();
            }
            firBasedSymbol = (FirBasedSymbol)firClassLikeSymbol;
        } else {
            firBasedSymbol = null;
        }
        return firBasedSymbol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean resolvesToSameStaticMethods(FirQualifiedAccessExpression existingCall, Candidate candidateCall) {
        FirBasedSymbol firBasedSymbol = FirReferenceUtilsKt.getSymbol((FirReference)existingCall.getCalleeReference());
        if (firBasedSymbol == null) {
            return false;
        }
        FirBasedSymbol existingSymbol = firBasedSymbol;
        FirBasedSymbol candidateSymbol = candidateCall.getSymbol();
        if (!Intrinsics.areEqual((Object)existingSymbol, (Object)candidateSymbol)) {
            return false;
        }
        FirDeclaration referencedDeclaration = existingSymbol.getFir();
        if (!(referencedDeclaration instanceof FirMemberDeclaration)) return false;
        FirMemberDeclaration $this$isStatic$iv = (FirMemberDeclaration)referencedDeclaration;
        boolean $i$f$isStatic = false;
        if (!$this$isStatic$iv.getStatus().isStatic()) return false;
        return true;
    }
}

