/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticLossRisk;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategyKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J4\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0017\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/diagnostics/LightTreePositioningStrategy;", "", "<init>", "()V", "markKtDiagnostic", "", "Lcom/intellij/openapi/util/TextRange;", "element", "Lorg/jetbrains/kotlin/KtSourceElement;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "mark", "node", "Lcom/intellij/lang/LighterASTNode;", "startOffset", "", "endOffset", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "isValid", "", "frontend.common-psi"})
public class LightTreePositioningStrategy {
    @NotNull
    public List<TextRange> markKtDiagnostic(@NotNull KtSourceElement element, @NotNull KtDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        return this.mark(element.getLighterASTNode(), element.getStartOffset(), element.getEndOffset(), element.getTreeStructure());
    }

    @NotNull
    public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(tree, "tree");
        return LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
    }

    @DiagnosticLossRisk
    public boolean isValid(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(tree, "tree");
        return !LightTreePositioningStrategyKt.access$hasSyntaxErrors(node, tree);
    }
}

