/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.lang.constant.Constable;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapperBase;
import org.jetbrains.kotlin.codegen.state.StaticTypeMapperForOldBackend;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public abstract class StackValue {
    public static final Local LOCAL_0 = StackValue.local(0, AsmTypes.OBJECT_TYPE);
    @NotNull
    public final Type type;
    @Nullable
    public final KotlinType kotlinType;
    private final boolean canHaveSideEffects;

    protected StackValue(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(0);
        }
        this(type2, null, true);
    }

    protected StackValue(@NotNull Type type2, boolean canHaveSideEffects) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(1);
        }
        this(type2, null, canHaveSideEffects);
    }

    protected StackValue(@NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(2);
        }
        this(type2, kotlinType, true);
    }

    protected StackValue(@NotNull Type type2, @Nullable KotlinType kotlinType, boolean canHaveSideEffects) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(3);
        }
        this.type = type2;
        this.kotlinType = kotlinType;
        this.canHaveSideEffects = canHaveSideEffects;
    }

    public void put(@NotNull InstructionAdapter v) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(4);
        }
        this.put(this.type, null, v, false);
    }

    public void put(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(5);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(6);
        }
        this.put(type2, null, v, false);
    }

    public void put(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(7);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(8);
        }
        this.put(type2, kotlinType, v, false);
    }

    public void put(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v, boolean skipReceiver) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(9);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(10);
        }
        if (!skipReceiver) {
            this.putReceiver(v, true);
        }
        this.putSelector(type2, kotlinType, v);
    }

    public abstract void putSelector(@NotNull Type var1, @Nullable KotlinType var2, @NotNull InstructionAdapter var3);

    public void putReceiver(@NotNull InstructionAdapter v, boolean isRead) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(11);
        }
    }

    public void store(@NotNull StackValue value2, @NotNull InstructionAdapter v) {
        if (value2 == null) {
            StackValue.$$$reportNull$$$0(12);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(13);
        }
        this.store(value2, v, false);
    }

    public void store(@NotNull StackValue value2, @NotNull InstructionAdapter v, boolean skipReceiver) {
        if (value2 == null) {
            StackValue.$$$reportNull$$$0(14);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(15);
        }
        if (!skipReceiver) {
            this.putReceiver(v, false);
        }
        value2.put(value2.type, value2.kotlinType, v);
        this.storeSelector(value2.type, value2.kotlinType, v);
    }

    protected void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
        if (topOfStackType == null) {
            StackValue.$$$reportNull$$$0(16);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(17);
        }
        throw new UnsupportedOperationException("Cannot store to value " + this);
    }

    @NotNull
    public static Local local(int index, @NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(18);
        }
        return new Local(index, type2);
    }

    public static Local local(int index, @NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(19);
        }
        return new Local(index, type2, kotlinType);
    }

    @NotNull
    public static StackValue onStack(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(20);
        }
        return StackValue.onStack(type2, null);
    }

    @NotNull
    public static StackValue onStack(@NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(21);
        }
        return type2 == Type.VOID_TYPE ? StackValue.none() : new OnStack(type2, kotlinType);
    }

    @NotNull
    public static StackValue constant(@Nullable Object value2, @NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(22);
        }
        return StackValue.constant(value2, type2, null);
    }

    @NotNull
    public static StackValue constant(@Nullable Object value2, @NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(23);
        }
        if (type2 == Type.BOOLEAN_TYPE) {
            assert (value2 instanceof Boolean) : "Value for boolean constant should have boolean type: " + value2;
            BranchedValue branchedValue = BranchedValue.Companion.booleanConstant((Boolean)value2);
            if (branchedValue == null) {
                StackValue.$$$reportNull$$$0(24);
            }
            return branchedValue;
        }
        return new Constant(value2, type2, kotlinType);
    }

    public static StackValue createDefaultValue(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(25);
        }
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return StackValue.constant(null, type2);
        }
        return StackValue.createDefaultPrimitiveValue(type2);
    }

    private static StackValue createDefaultPrimitiveValue(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(26);
        }
        assert (1 <= type2.getSort() && type2.getSort() <= 8) : "'createDefaultPrimitiveValue' method should be called only for primitive types, but " + type2;
        Constable value2 = 0;
        if (type2.getSort() == 1) {
            value2 = Boolean.FALSE;
        } else if (type2.getSort() == 6) {
            value2 = new Float(0.0);
        } else if (type2.getSort() == 8) {
            value2 = new Double(0.0);
        } else if (type2.getSort() == 7) {
            value2 = new Long(0L);
        }
        return StackValue.constant(value2, type2);
    }

    @NotNull
    public static Field field(@NotNull Type type2, @NotNull Type owner, @NotNull String name2, @NotNull StackValue receiver) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(27);
        }
        if (owner == null) {
            StackValue.$$$reportNull$$$0(28);
        }
        if (name2 == null) {
            StackValue.$$$reportNull$$$0(29);
        }
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(30);
        }
        return new Field(type2, null, owner, name2, receiver);
    }

    private static void box(Type type2, Type toType, InstructionAdapter v) {
        Type boxedType;
        if (type2 == Type.INT_TYPE) {
            if (toType.getInternalName().equals("java/lang/Byte")) {
                type2 = Type.BYTE_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Short")) {
                type2 = Type.SHORT_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Long")) {
                type2 = Type.LONG_TYPE;
            }
            v.cast(Type.INT_TYPE, type2);
        }
        if ((boxedType = AsmUtil.boxType(type2)) == type2) {
            return;
        }
        v.invokestatic(boxedType.getInternalName(), "valueOf", Type.getMethodDescriptor(boxedType, type2), false);
        StackValue.coerce(boxedType, toType, v);
    }

    private static void unbox(Type methodOwner, Type type2, InstructionAdapter v) {
        assert (AsmUtil.isPrimitive(type2)) : "Unboxing should be performed to primitive type, but " + type2.getClassName();
        v.invokevirtual(methodOwner.getInternalName(), type2.getClassName() + "Value", "()" + type2.getDescriptor(), false);
    }

    private static void boxInlineClass(@NotNull KotlinTypeMarker kotlinType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (kotlinType == null) {
            StackValue.$$$reportNull$$$0(31);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(32);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(33);
        }
        Type boxed = typeMapper2.mapTypeCommon(kotlinType, TypeMappingMode.CLASS_DECLARATION);
        Type unboxed = KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(kotlinType, typeMapper2);
        boolean isNullable = typeMapper2.getTypeSystem().isNullableType(kotlinType) && !AsmUtil.isPrimitive(unboxed);
        StackValue.boxInlineClass(unboxed, boxed, isNullable, v);
    }

    public static void boxInlineClass(@NotNull Type unboxed, @NotNull Type boxed, boolean isNullable, @NotNull InstructionAdapter v) {
        if (unboxed == null) {
            StackValue.$$$reportNull$$$0(34);
        }
        if (boxed == null) {
            StackValue.$$$reportNull$$$0(35);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(36);
        }
        if (isNullable) {
            StackValue.boxOrUnboxWithNullCheck(v, vv -> StackValue.invokeBoxMethod(vv, boxed, unboxed));
        } else {
            StackValue.invokeBoxMethod(v, boxed, unboxed);
        }
    }

    private static void invokeBoxMethod(@NotNull InstructionAdapter v, @NotNull Type boxedType, @NotNull Type underlyingType) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(37);
        }
        if (boxedType == null) {
            StackValue.$$$reportNull$$$0(38);
        }
        if (underlyingType == null) {
            StackValue.$$$reportNull$$$0(39);
        }
        v.invokestatic(boxedType.getInternalName(), KotlinTypeMapper.BOX_JVM_METHOD_NAME, Type.getMethodDescriptor(boxedType, underlyingType), false);
    }

    public static void unboxInlineClass(@NotNull Type type2, @NotNull KotlinTypeMarker targetInlineClassType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(40);
        }
        if (targetInlineClassType == null) {
            StackValue.$$$reportNull$$$0(41);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(42);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(43);
        }
        Type boxed = typeMapper2.mapTypeCommon(targetInlineClassType, TypeMappingMode.CLASS_DECLARATION);
        Type unboxed = KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(targetInlineClassType, typeMapper2);
        boolean isNullable = typeMapper2.getTypeSystem().isNullableType(targetInlineClassType) && !AsmUtil.isPrimitive(unboxed);
        StackValue.unboxInlineClass(type2, boxed, unboxed, isNullable, v);
    }

    public static void unboxInlineClass(@NotNull Type type2, @NotNull Type boxed, @NotNull Type unboxed, boolean isNullable, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(44);
        }
        if (boxed == null) {
            StackValue.$$$reportNull$$$0(45);
        }
        if (unboxed == null) {
            StackValue.$$$reportNull$$$0(46);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(47);
        }
        StackValue.coerce(type2, boxed, v);
        if (isNullable) {
            StackValue.boxOrUnboxWithNullCheck(v, vv -> StackValue.invokeUnboxMethod(vv, boxed, unboxed));
        } else {
            StackValue.invokeUnboxMethod(v, boxed, unboxed);
        }
    }

    private static void invokeUnboxMethod(@NotNull InstructionAdapter v, @NotNull Type owner, @NotNull Type resultType) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(48);
        }
        if (owner == null) {
            StackValue.$$$reportNull$$$0(49);
        }
        if (resultType == null) {
            StackValue.$$$reportNull$$$0(50);
        }
        v.invokevirtual(owner.getInternalName(), KotlinTypeMapper.UNBOX_JVM_METHOD_NAME, "()" + resultType.getDescriptor(), false);
    }

    private static void boxOrUnboxWithNullCheck(@NotNull InstructionAdapter v, @NotNull Consumer<InstructionAdapter> body2) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(51);
        }
        if (body2 == null) {
            StackValue.$$$reportNull$$$0(52);
        }
        Label lNull = new Label();
        Label lDone = new Label();
        v.dup();
        v.ifnull(lNull);
        body2.accept(v);
        v.goTo(lDone);
        v.mark(lNull);
        v.pop();
        v.aconst(null);
        v.mark(lDone);
    }

    protected void coerceTo(@NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v) {
        if (toType == null) {
            StackValue.$$$reportNull$$$0(53);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(54);
        }
        StackValue.coerce(this.type, this.kotlinType, toType, toKotlinType, v);
    }

    protected void coerceFrom(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
        if (topOfStackType == null) {
            StackValue.$$$reportNull$$$0(55);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(56);
        }
        StackValue.coerce(topOfStackType, topOfStackKotlinType, this.type, this.kotlinType, v);
    }

    public static void coerce(@NotNull Type fromType, @Nullable KotlinType fromKotlinType, @NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(57);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(58);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(59);
        }
        if (StackValue.coerceInlineClasses(fromType, fromKotlinType, toType, toKotlinType, v, StaticTypeMapperForOldBackend.INSTANCE)) {
            return;
        }
        StackValue.coerce(fromType, toType, v);
    }

    public static boolean requiresInlineClassBoxingOrUnboxing(@NotNull Type fromType, @Nullable KotlinType fromKotlinType, @NotNull Type toType, @Nullable KotlinType toKotlinType) {
        boolean isToTypeUnboxed;
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(60);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(61);
        }
        if (fromKotlinType == null || toKotlinType == null) {
            return false;
        }
        boolean isFromTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(fromKotlinType);
        boolean isToTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(toKotlinType);
        if (!isFromTypeInlineClass && !isToTypeInlineClass) {
            return false;
        }
        boolean isFromTypeUnboxed = isFromTypeInlineClass && StackValue.isUnboxedInlineClass(fromKotlinType, fromType);
        boolean bl = isToTypeUnboxed = isToTypeInlineClass && StackValue.isUnboxedInlineClass(toKotlinType, toType);
        if (isFromTypeInlineClass && isToTypeInlineClass) {
            return isFromTypeUnboxed != isToTypeUnboxed;
        }
        return isFromTypeInlineClass && isFromTypeUnboxed || isToTypeInlineClass && isToTypeUnboxed;
    }

    private static boolean coerceInlineClasses(@NotNull Type fromType, @Nullable KotlinType fromKotlinType, @NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(62);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(63);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(64);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(65);
        }
        if (fromKotlinType == null || toKotlinType == null) {
            return false;
        }
        boolean isFromTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(fromKotlinType);
        boolean isToTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(toKotlinType);
        if (!isFromTypeInlineClass && !isToTypeInlineClass) {
            return false;
        }
        if (fromKotlinType.equals(toKotlinType) && fromType.equals(toType)) {
            return true;
        }
        if (isFromTypeInlineClass && isToTypeInlineClass) {
            boolean isFromTypeUnboxed = StackValue.isUnboxedInlineClass(fromKotlinType, fromType);
            boolean isToTypeUnboxed = StackValue.isUnboxedInlineClass(toKotlinType, toType);
            if (isFromTypeUnboxed && !isToTypeUnboxed) {
                StackValue.boxInlineClass(fromKotlinType, v, typeMapper2);
                return true;
            }
            if (!isFromTypeUnboxed && isToTypeUnboxed) {
                StackValue.unboxInlineClass(fromType, toKotlinType, v, typeMapper2);
                return true;
            }
        } else if (isFromTypeInlineClass) {
            if (StackValue.isUnboxedInlineClass(fromKotlinType, fromType)) {
                StackValue.boxInlineClass(fromKotlinType, v, typeMapper2);
                return true;
            }
        } else if (StackValue.isUnboxedInlineClass(toKotlinType, toType)) {
            StackValue.unboxInlineClass(fromType, toKotlinType, v, typeMapper2);
            return true;
        }
        return false;
    }

    private static boolean isUnboxedInlineClass(@NotNull KotlinType kotlinType, @NotNull Type actualType) {
        if (kotlinType == null) {
            StackValue.$$$reportNull$$$0(66);
        }
        if (actualType == null) {
            StackValue.$$$reportNull$$$0(67);
        }
        return KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(kotlinType, StaticTypeMapperForOldBackend.INSTANCE).equals(actualType);
    }

    public static void coerce(@NotNull Type fromType, @NotNull Type toType, @NotNull InstructionAdapter v) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(68);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(69);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(70);
        }
        StackValue.coerce(fromType, toType, v, false);
    }

    public static void coerce(@NotNull Type fromType, @NotNull Type toType, @NotNull InstructionAdapter v, boolean forceSelfCast) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(71);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(72);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(73);
        }
        if (toType.equals(fromType) && !forceSelfCast) {
            return;
        }
        if (toType.getSort() == 0) {
            AsmUtil.pop(v, fromType);
        } else if (fromType.getSort() == 0) {
            if (toType.equals(AsmTypes.UNIT_TYPE) || toType.equals(AsmTypes.OBJECT_TYPE)) {
                StackValue.putUnitInstance(v);
            } else {
                AsmUtil.pushDefaultValueOnStack(toType, v);
            }
        } else if (toType.equals(AsmTypes.UNIT_TYPE)) {
            if (fromType.equals(AsmTypes.getType(Object.class))) {
                v.checkcast(AsmTypes.UNIT_TYPE);
            } else if (!fromType.equals(AsmTypes.getType(Void.class))) {
                AsmUtil.pop(v, fromType);
                StackValue.putUnitInstance(v);
            }
        } else if (toType.getSort() == 9) {
            if (fromType.getSort() != 9) {
                v.checkcast(toType);
            } else if (toType.getDimensions() != fromType.getDimensions()) {
                v.checkcast(toType);
            } else if (!toType.getElementType().equals(AsmTypes.OBJECT_TYPE)) {
                v.checkcast(toType);
            }
        } else if (toType.getSort() == 10) {
            if (fromType.getSort() == 10 || fromType.getSort() == 9) {
                if (!toType.equals(AsmTypes.OBJECT_TYPE)) {
                    v.checkcast(toType);
                }
            } else {
                StackValue.box(fromType, toType, v);
            }
        } else if (fromType.getSort() == 10 || fromType.getSort() == 9) {
            Type unboxedType = AsmUtil.unboxPrimitiveTypeOrNull(fromType);
            if (unboxedType != null) {
                StackValue.unbox(fromType, unboxedType, v);
                StackValue.coerce(unboxedType, toType, v);
            } else if (toType.getSort() == 1) {
                StackValue.coerce(fromType, AsmTypes.BOOLEAN_WRAPPER_TYPE, v);
                StackValue.unbox(AsmTypes.BOOLEAN_WRAPPER_TYPE, Type.BOOLEAN_TYPE, v);
            } else if (toType.getSort() == 2) {
                if (fromType.equals(AsmTypes.NUMBER_TYPE)) {
                    StackValue.unbox(AsmTypes.NUMBER_TYPE, Type.INT_TYPE, v);
                    v.visitInsn(146);
                } else {
                    StackValue.coerce(fromType, AsmTypes.CHARACTER_WRAPPER_TYPE, v);
                    StackValue.unbox(AsmTypes.CHARACTER_WRAPPER_TYPE, Type.CHAR_TYPE, v);
                }
            } else {
                StackValue.coerce(fromType, AsmTypes.NUMBER_TYPE, v);
                StackValue.unbox(AsmTypes.NUMBER_TYPE, toType, v);
            }
        } else {
            v.cast(fromType, toType);
        }
    }

    private static void putUnitInstance(@NotNull InstructionAdapter v) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(74);
        }
        v.visitFieldInsn(178, AsmTypes.UNIT_TYPE.getInternalName(), "INSTANCE", AsmTypes.UNIT_TYPE.getDescriptor());
    }

    public static StackValue none() {
        return None.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 32: 
            case 36: 
            case 37: 
            case 42: 
            case 47: 
            case 48: 
            case 51: 
            case 54: 
            case 56: 
            case 59: 
            case 64: 
            case 70: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topOfStackType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/StackValue";
                break;
            }
            case 28: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 31: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinType";
                break;
            }
            case 33: 
            case 43: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 34: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unboxed";
                break;
            }
            case 35: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxed";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedType";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingType";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetInlineClassType";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 53: 
            case 58: 
            case 61: 
            case 63: 
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 57: 
            case 60: 
            case 62: 
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "constant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putReceiver";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "storeSelector";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "local";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "onStack";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "constant";
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultValue";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultPrimitiveValue";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "field";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "boxInlineClass";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "invokeBoxMethod";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "unboxInlineClass";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "invokeUnboxMethod";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "boxOrUnboxWithNullCheck";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "coerceTo";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "coerceFrom";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "coerce";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "requiresInlineClassBoxingOrUnboxing";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "coerceInlineClasses";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isUnboxedInlineClass";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "putUnitInstance";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 24: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Field
    extends StackValue {
        public final Type owner;
        public final String name;
        @NotNull
        public final StackValue receiver;

        public Field(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull Type owner, @NotNull String name2, @NotNull StackValue receiver) {
            if (type2 == null) {
                Field.$$$reportNull$$$0(0);
            }
            if (owner == null) {
                Field.$$$reportNull$$$0(1);
            }
            if (name2 == null) {
                Field.$$$reportNull$$$0(2);
            }
            if (receiver == null) {
                Field.$$$reportNull$$$0(3);
            }
            super(type2, kotlinType, receiver.canHaveSideEffects);
            this.owner = owner;
            this.name = name2;
            this.receiver = receiver;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Field.$$$reportNull$$$0(4);
            }
            if (v == null) {
                Field.$$$reportNull$$$0(5);
            }
            v.visitFieldInsn(180, this.owner.getInternalName(), this.name, this.type.getDescriptor());
            this.coerceTo(type2, kotlinType, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                Field.$$$reportNull$$$0(6);
            }
            if (v == null) {
                Field.$$$reportNull$$$0(7);
            }
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v);
            v.visitFieldInsn(181, this.owner.getInternalName(), this.name, this.type.getDescriptor());
        }

        @Override
        public void putReceiver(@NotNull InstructionAdapter v, boolean isRead) {
            if (v == null) {
                Field.$$$reportNull$$$0(8);
            }
            this.receiver.put(this.receiver.type, this.receiver.kotlinType, v);
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                Field.$$$reportNull$$$0(9);
            }
            if (v == null) {
                Field.$$$reportNull$$$0(10);
            }
            if (!skipReceiver) {
                this.putReceiver(v, false);
            }
            rightSide.put(rightSide.type, rightSide.kotlinType, v);
            this.storeSelector(rightSide.type, rightSide.kotlinType, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightSide";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Field";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putReceiver";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Constant
    extends StackValue {
        @Nullable
        public final Object value;

        public Constant(@Nullable Object value2, Type type2, KotlinType kotlinType) {
            super(type2, kotlinType, false);
            assert (!Type.BOOLEAN_TYPE.equals(type2)) : "Boolean constants should be created via 'StackValue.constant'";
            this.value = value2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Constant.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Constant.$$$reportNull$$$0(1);
            }
            if (this.value instanceof Integer || this.value instanceof Byte || this.value instanceof Short) {
                v.iconst(((Number)this.value).intValue());
            } else if (this.value instanceof Character) {
                v.iconst(((Character)this.value).charValue());
            } else if (this.value instanceof Long) {
                v.lconst((Long)this.value);
            } else if (this.value instanceof Float) {
                v.fconst(((Float)this.value).floatValue());
            } else if (this.value instanceof Double) {
                v.dconst((Double)this.value);
            } else {
                v.aconst(this.value);
            }
            if (this.value != null || AsmUtil.isPrimitive(type2)) {
                this.coerceTo(type2, kotlinType, v);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$Constant";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OnStack
    extends StackValue {
        public OnStack(Type type2, KotlinType kotlinType) {
            super(type2, kotlinType);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                OnStack.$$$reportNull$$$0(0);
            }
            if (v == null) {
                OnStack.$$$reportNull$$$0(1);
            }
            this.coerceTo(type2, kotlinType, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$OnStack";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Local
    extends StackValue {
        public final int index;

        private Local(int index, Type type2, KotlinType kotlinType) {
            super(type2, kotlinType, false);
            if (index < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
            this.index = index;
        }

        private Local(int index, Type type2) {
            this(index, type2, (KotlinType)null);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Local.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Local.$$$reportNull$$$0(1);
            }
            v.load(this.index, this.type);
            this.coerceTo(type2, kotlinType, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                Local.$$$reportNull$$$0(2);
            }
            if (v == null) {
                Local.$$$reportNull$$$0(3);
            }
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v);
            v.store(this.index, this.type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Local";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class None
    extends StackValue {
        public static final None INSTANCE = new None();

        private None() {
            super(Type.VOID_TYPE, false);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                None.$$$reportNull$$$0(0);
            }
            if (v == null) {
                None.$$$reportNull$$$0(1);
            }
            this.coerceTo(type2, kotlinType, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$None";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

