/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "transformer", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getTransformer", "()Lkotlin/jvm/functions/Function1;", "lower", "", "irFile", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nAnnotationImplementationTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationImplementationTransformer.kt\norg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,322:1\n1869#2,2:323\n*S KotlinDebug\n*F\n+ 1 AnnotationImplementationTransformer.kt\norg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationLowering\n*L\n63#1:323,2\n*E\n"})
public class AnnotationImplementationLowering
implements FileLoweringPass {
    @NotNull
    private final Function1<IrFile, AnnotationImplementationTransformer> transformer;

    public AnnotationImplementationLowering(@NotNull Function1<? super IrFile, ? extends AnnotationImplementationTransformer> transformer2) {
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        this.transformer = transformer2;
    }

    @NotNull
    public final Function1<IrFile, AnnotationImplementationTransformer> getTransformer() {
        return this.transformer;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        AnnotationImplementationTransformer tf = this.transformer.invoke(irFile);
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, tf);
        Iterable $this$forEach$iv = tf.getImplementations$ir_backend_common().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrClass it = (IrClass)element$iv;
            boolean bl = false;
            IrDeclarationParent irDeclarationParent = it.getParent();
            Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
            IrDeclarationContainer parentClass = (IrDeclarationContainer)irDeclarationParent;
            ((Collection)parentClass.getDeclarations()).add(it);
        }
    }
}

