/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class WalkingState<T> {
    private boolean isDown;
    protected boolean startedWalking;
    private final TreeGuide<T> myWalker;
    private boolean stopped;
    private static boolean isUnitTestMode = false;

    public void elementFinished(@NotNull T element) {
        if (element == null) {
            WalkingState.$$$reportNull$$$0(0);
        }
    }

    public WalkingState(@NotNull TreeGuide<T> delegate) {
        if (delegate == null) {
            WalkingState.$$$reportNull$$$0(1);
        }
        this.myWalker = delegate;
    }

    public void visit(@NotNull T element) {
        if (element == null) {
            WalkingState.$$$reportNull$$$0(2);
        }
        this.elementStarted(element);
    }

    public void elementStarted(@NotNull T element) {
        if (element == null) {
            WalkingState.$$$reportNull$$$0(3);
        }
        this.isDown = true;
        if (!this.startedWalking) {
            this.stopped = false;
            this.startedWalking = true;
            try {
                this.walkChildren(element);
            }
            finally {
                this.startedWalking = false;
            }
        }
    }

    private void walkChildren(@NotNull T root) {
        if (root == null) {
            WalkingState.$$$reportNull$$$0(4);
        }
        T element = this.next(root, root, this.isDown);
        while (element != null && !this.stopped) {
            this.isDown = false;
            if (isUnitTestMode) {
                T parent2 = this.myWalker.getParent(element);
                T next = this.myWalker.getNextSibling(element);
                this.visit(element);
                assert (this.myWalker.getNextSibling(element) == next) : "Next sibling of the element '" + element + "' changed. Was: " + next + "; Now:" + this.myWalker.getNextSibling(element) + "; Root:" + root;
                assert (this.myWalker.getParent(element) == parent2) : "Parent of the element '" + element + "' changed. Was: " + parent2 + "; Now:" + this.myWalker.getParent(element) + "; Root:" + root;
            } else {
                this.visit(element);
            }
            element = this.next(element, root, this.isDown);
        }
    }

    public T next(T element, @NotNull T root, boolean isDown) {
        T child;
        if (root == null) {
            WalkingState.$$$reportNull$$$0(5);
        }
        if (isDown && (child = this.myWalker.getFirstChild(element)) != null) {
            return child;
        }
        while (element != root && element != null) {
            T next = this.myWalker.getNextSibling(element);
            this.elementFinished(element);
            if (next != null) {
                T nextPrev = this.myWalker.getPrevSibling(next);
                if (nextPrev != element) {
                    T top;
                    String msg = "Element: " + element + "; next: " + next + "; next.prev: " + nextPrev;
                    while ((top = this.myWalker.getParent(element)) != null && top != root) {
                        element = top;
                    }
                    assert (false) : msg + " Top:" + element;
                }
                return next;
            }
            element = this.myWalker.getParent(element);
        }
        if (element != null) {
            this.elementFinished(element);
        }
        return null;
    }

    public void startedWalking() {
        this.startedWalking = true;
    }

    public void stopWalking() {
        this.stopped = true;
    }

    public static <T> boolean processAll(@NotNull T root, @NotNull TreeGuide<T> treeGuide, final @NotNull Processor<? super T> processor) {
        if (root == null) {
            WalkingState.$$$reportNull$$$0(6);
        }
        if (treeGuide == null) {
            WalkingState.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            WalkingState.$$$reportNull$$$0(8);
        }
        final boolean[] result2 = new boolean[]{true};
        new WalkingState<T>(treeGuide){

            @Override
            public void visit(@NotNull T element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!processor.process(element)) {
                    this.stopWalking();
                    result2[0] = false;
                } else {
                    super.visit(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/WalkingState$1", "visit"));
            }
        }.visit(root);
        return result2[0];
    }

    @TestOnly
    public static void setUnitTestMode() {
        isUnitTestMode = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeGuide";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/WalkingState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "elementFinished";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "elementStarted";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "walkChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "next";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface TreeGuide<T> {
        public T getNextSibling(@NotNull T var1);

        public T getPrevSibling(@NotNull T var1);

        public T getFirstChild(@NotNull T var1);

        public T getParent(@NotNull T var1);
    }
}

