/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTypeRegistry {
    private static Supplier<? extends FileTypeRegistry> instanceGetter;

    @ApiStatus.Internal
    public static Supplier<? extends FileTypeRegistry> setInstanceSupplier(@NotNull Supplier<? extends FileTypeRegistry> supplier) {
        if (supplier == null) {
            FileTypeRegistry.$$$reportNull$$$0(0);
        }
        Supplier<? extends FileTypeRegistry> oldValue = instanceGetter;
        instanceGetter = supplier;
        return oldValue;
    }

    public abstract boolean isFileIgnored(@NotNull VirtualFile var1);

    public boolean isFileOfType(@NotNull VirtualFile file2, @NotNull FileType type2) {
        if (file2 == null) {
            FileTypeRegistry.$$$reportNull$$$0(1);
        }
        if (type2 == null) {
            FileTypeRegistry.$$$reportNull$$$0(2);
        }
        return file2.getFileType() == type2;
    }

    @Nullable
    public LanguageFileType findFileTypeByLanguage(@NotNull Language language2) {
        if (language2 == null) {
            FileTypeRegistry.$$$reportNull$$$0(3);
        }
        return language2.findMyFileType(this.getRegisteredFileTypes());
    }

    public static FileTypeRegistry getInstance() {
        Supplier<? extends FileTypeRegistry> instanceGetter = FileTypeRegistry.instanceGetter;
        if (instanceGetter == null) {
            return (FileTypeRegistry)ApplicationManager.getApplication().getServiceByClassName("com.intellij.openapi.fileTypes.FileTypeManager");
        }
        return instanceGetter.get();
    }

    public abstract FileType @NotNull [] getRegisteredFileTypes();

    @NotNull
    public abstract FileType getFileTypeByFile(@NotNull VirtualFile var1);

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2, byte @Nullable [] content) {
        if (file2 == null) {
            FileTypeRegistry.$$$reportNull$$$0(4);
        }
        FileType fileType = this.getFileTypeByFile(file2);
        if (fileType == null) {
            FileTypeRegistry.$$$reportNull$$$0(5);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull CharSequence fileNameSeq) {
        if (fileNameSeq == null) {
            FileTypeRegistry.$$$reportNull$$$0(6);
        }
        FileType fileType = this.getFileTypeByFileName(fileNameSeq.toString());
        if (fileType == null) {
            FileTypeRegistry.$$$reportNull$$$0(7);
        }
        return fileType;
    }

    @NotNull
    public abstract FileType getFileTypeByFileName(@NotNull String var1);

    public abstract FileType findFileTypeByName(@NotNull String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/FileTypeRegistry";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameSeq";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/FileTypeRegistry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setInstanceSupplier";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFileOfType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFile";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFileName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

