/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u0003H\u0016J\u001c\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/formatter/SyntheticKotlinBlock;", "Lcom/intellij/formatting/ASTBlock;", "node", "Lcom/intellij/lang/ASTNode;", "subBlocks", "", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "wrap", "Lcom/intellij/formatting/Wrap;", "spacingBuilder", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;", "createParentSyntheticSpacingBlock", "Lkotlin/Function1;", "<init>", "(Lcom/intellij/lang/ASTNode;Ljava/util/List;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;Lcom/intellij/formatting/Wrap;Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;Lkotlin/jvm/functions/Function1;)V", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "getSubBlocks", "getWrap", "getIndent", "getAlignment", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "", "isIncomplete", "", "isLeaf", "getNode", "getSpacing", "Lcom/intellij/formatting/Spacing;", "child1", "Lcom/intellij/formatting/Block;", "child2", "toString", "", "kotlin.formatter.minimal"})
public final class SyntheticKotlinBlock
implements ASTBlock {
    @NotNull
    private final ASTNode node;
    @NotNull
    private final List<ASTBlock> subBlocks;
    @Nullable
    private final Alignment alignment;
    @Nullable
    private final Indent indent;
    @Nullable
    private final Wrap wrap;
    @NotNull
    private final KotlinSpacingBuilder spacingBuilder;
    @NotNull
    private final Function1<ASTNode, ASTBlock> createParentSyntheticSpacingBlock;
    @NotNull
    private final TextRange textRange;

    public SyntheticKotlinBlock(@NotNull ASTNode node, @NotNull List<? extends ASTBlock> subBlocks, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @NotNull KotlinSpacingBuilder spacingBuilder, @NotNull Function1<? super ASTNode, ? extends ASTBlock> createParentSyntheticSpacingBlock) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(subBlocks, (String)"subBlocks");
        Intrinsics.checkNotNullParameter((Object)spacingBuilder, (String)"spacingBuilder");
        Intrinsics.checkNotNullParameter(createParentSyntheticSpacingBlock, (String)"createParentSyntheticSpacingBlock");
        this.node = node;
        this.subBlocks = subBlocks;
        this.alignment = alignment;
        this.indent = indent;
        this.wrap = wrap;
        this.spacingBuilder = spacingBuilder;
        this.createParentSyntheticSpacingBlock = createParentSyntheticSpacingBlock;
        this.textRange = new TextRange(((ASTBlock)CollectionsKt.first(this.subBlocks)).getTextRange().getStartOffset(), ((ASTBlock)CollectionsKt.last(this.subBlocks)).getTextRange().getEndOffset());
    }

    @NotNull
    public TextRange getTextRange() {
        return this.textRange;
    }

    @NotNull
    public List<ASTBlock> getSubBlocks() {
        return this.subBlocks;
    }

    @Nullable
    public Wrap getWrap() {
        return this.wrap;
    }

    @Nullable
    public Indent getIndent() {
        return this.indent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.alignment;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(this.getIndent(), null);
    }

    public boolean isIncomplete() {
        return ((ASTBlock)CollectionsKt.last(this.getSubBlocks())).isIncomplete();
    }

    public boolean isLeaf() {
        return false;
    }

    @NotNull
    public ASTNode getNode() {
        return this.node;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        return this.spacingBuilder.getSpacing((Block)this.createParentSyntheticSpacingBlock.invoke((Object)this.node), child1, child2);
    }

    @NotNull
    public String toString() {
        PsiFile file;
        ASTBlock child = (ASTBlock)CollectionsKt.first(this.subBlocks);
        ASTNode treeNode = null;
        while (treeNode == null) {
            if (child instanceof SyntheticKotlinBlock) {
                child = (ASTBlock)CollectionsKt.first(((SyntheticKotlinBlock)child).getSubBlocks());
                continue;
            }
            treeNode = child.getNode();
        }
        TextRange textRange = this.getTextRange();
        PsiElement psi = treeNode.getPsi();
        if (psi != null && (file = psi.getContainingFile()) != null) {
            String string = file.getText();
            Intrinsics.checkNotNull((Object)string);
            return string.subSequence(textRange.getStartOffset(), textRange.getEndOffset()) + " " + textRange;
        }
        return this.getClass().getName() + ": " + textRange;
    }
}

