/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ui;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ExtractSuperInfo;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.KotlinExtractInterfaceHandler;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ui.KotlinExtractSuperDialogBase;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfoKt;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfoStorageKt;
import org.jetbrains.kotlin.idea.refactoring.pullUp.CommonPullUpUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0012\u0010\u0012\u001a\f0\u0011\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u0014H\u0014J\u0012\u0010\u0015\u001a\f0\u0011\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u0014H\u0014J\u0012\u0010\u0016\u001a\f0\u0011\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u0014H\u0014J\u0012\u0010\u0017\u001a\f0\u0011\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u0014H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0019H\u0014J\u0012\u0010\u001c\u001a\f0\u0011\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u0014H\u0014J\b\u0010\u001d\u001a\u00020\u0011H\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0014\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractInterfaceDialog;", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractSuperDialogBase;", "originalClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "targetParent", "Lcom/intellij/psi/PsiElement;", "conflictChecker", "Lkotlin/Function1;", "", "refactoring", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ExtractSuperInfo;", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "createMemberInfoModel", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractSuperDialogBase$MemberInfoModelBase;", "getDestinationPackageRecentKey", "", "getClassNameLabelText", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getPackageNameLabelText", "getEntityName", "getTopLabelText", "getDocCommentPolicySetting", "", "setDocCommentPolicySetting", "policy", "getExtractedSuperNameNotSpecifiedMessage", "getHelpId", "createExtractedSuperNameField", "Ljavax/swing/JTextField;", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinExtractInterfaceDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExtractInterfaceDialog.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractInterfaceDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n827#2:121\n855#2,2:122\n1869#2,2:124\n1#3:126\n*S KotlinDebug\n*F\n+ 1 KotlinExtractInterfaceDialog.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractInterfaceDialog\n*L\n46#1:121\n46#1:122,2\n51#1:124,2\n*E\n"})
public final class KotlinExtractInterfaceDialog
extends KotlinExtractSuperDialogBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DESTINATION_PACKAGE_RECENT_KEY = "KotlinExtractInterfaceDialog.RECENT_KEYS";

    public KotlinExtractInterfaceDialog(@NotNull KtClassOrObject originalClass, @NotNull PsiElement targetParent, @NotNull Function1<? super KotlinExtractSuperDialogBase, Boolean> conflictChecker, @NotNull Function1<? super ExtractSuperInfo, Unit> refactoring) {
        Intrinsics.checkNotNullParameter((Object)originalClass, (String)"originalClass");
        Intrinsics.checkNotNullParameter((Object)targetParent, (String)"targetParent");
        Intrinsics.checkNotNullParameter(conflictChecker, (String)"conflictChecker");
        Intrinsics.checkNotNullParameter(refactoring, (String)"refactoring");
        super(originalClass, targetParent, conflictChecker, true, KotlinExtractInterfaceHandler.INSTANCE.getREFACTORING_NAME(), refactoring);
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected KotlinExtractSuperDialogBase.MemberInfoModelBase createMemberInfoModel() {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = KotlinMemberInfoStorageKt.extractClassMembers$default(this.getOriginalClass(), false, null, 6, null);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            KotlinMemberInfo it = (KotlinMemberInfo)((Object)element$iv$iv);
            boolean bl = false;
            KtNamedDeclaration member = (KtNamedDeclaration)it.getMember();
            if (member instanceof KtClass && ((KtClass)member).hasModifier(KtTokens.INNER_KEYWORD) || member instanceof KtParameter && ((KtParameter)member).hasModifier(KtTokens.PRIVATE_KEYWORD)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List extractableMemberInfos = (List)destination$iv$iv;
        Iterable $this$forEach$iv = extractableMemberInfos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinMemberInfo it = (KotlinMemberInfo)((Object)element$iv);
            boolean bl = false;
            it.setToAbstract(true);
        }
        KtClassOrObject ktClassOrObject = this.getOriginalClass();
        Function1<KtNamedDeclaration, Boolean> function1 = CommonPullUpUtilsKt.getInterfaceContainmentVerifier((Function0<? extends List<KotlinMemberInfo>>)((Function0)() -> KotlinExtractInterfaceDialog.createMemberInfoModel$lambda$2(this)));
        return new KotlinExtractSuperDialogBase.MemberInfoModelBase(extractableMemberInfos, this, ktClassOrObject, function1){
            final /* synthetic */ KotlinExtractInterfaceDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $extractableMemberInfos, $super_call_param$2);
            }

            public boolean isMemberEnabled(KotlinMemberInfo member) {
                Intrinsics.checkNotNullParameter((Object)((Object)member), (String)"member");
                if (!super.isMemberEnabled(member)) {
                    return false;
                }
                KtNamedDeclaration declaration = (KtNamedDeclaration)member.getMember();
                return !declaration.hasModifier(KtTokens.INLINE_KEYWORD) && !declaration.hasModifier(KtTokens.EXTERNAL_KEYWORD) && !declaration.hasModifier(KtTokens.LATEINIT_KEYWORD);
            }

            public boolean isAbstractEnabled(KotlinMemberInfo memberInfo) {
                Intrinsics.checkNotNullParameter((Object)((Object)memberInfo), (String)"memberInfo");
                if (!super.isAbstractEnabled(memberInfo)) {
                    return false;
                }
                KtNamedDeclaration member = (KtNamedDeclaration)memberInfo.getMember();
                Intrinsics.checkNotNull((Object)member);
                if (CommonPullUpUtilsKt.isAbstractInInterface(member, this.this$0.getOriginalClass())) {
                    return false;
                }
                if (KotlinPsiUtils.isConstructorDeclaredProperty(member)) {
                    return false;
                }
                return member instanceof KtNamedFunction || member instanceof KtProperty && !CommonPullUpUtilsKt.mustBeAbstractInInterface((KtProperty)member) || member instanceof KtParameter;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isAbstractWhenDisabled(KotlinMemberInfo memberInfo) {
                Intrinsics.checkNotNullParameter((Object)((Object)memberInfo), (String)"memberInfo");
                KtNamedDeclaration member = (KtNamedDeclaration)memberInfo.getMember();
                if (member instanceof KtProperty) return true;
                Intrinsics.checkNotNull((Object)member);
                if (CommonPullUpUtilsKt.isAbstractInInterface(member, this.this$0.getOriginalClass())) return true;
                if (!KotlinPsiUtils.isConstructorDeclaredProperty(member)) return false;
                return true;
            }

            public int checkForProblems(KotlinMemberInfo memberInfo) {
                Intrinsics.checkNotNullParameter((Object)((Object)memberInfo), (String)"memberInfo");
                int result2 = super.checkForProblems((MemberInfoBase)memberInfo);
                if (result2 != 0) {
                    return result2;
                }
                if (!memberInfo.isSuperClass() || !Intrinsics.areEqual((Object)memberInfo.getOverrides(), (Object)false) || memberInfo.isChecked()) {
                    return 0;
                }
                PsiMember psiMember = KotlinMemberInfoKt.lightElementForMemberInfo((KtNamedDeclaration)memberInfo.getMember());
                PsiClass psiClass = psiMember instanceof PsiClass ? (PsiClass)psiMember : null;
                if (psiClass == null) {
                    return 0;
                }
                PsiClass psiSuperInterface = psiClass;
                for (KotlinMemberInfo info2 : this.getMemberInfos()) {
                    PsiMethod psiMethodToCheck;
                    KtNamedDeclaration member;
                    if (!info2.isChecked() || info2.isToAbstract() || (KtNamedDeclaration)info2.getMember() == null) continue;
                    PsiMember psiMember2 = KotlinMemberInfoKt.lightElementForMemberInfo(member);
                    PsiMethod psiMethod = psiMember2 instanceof PsiMethod ? (PsiMethod)psiMember2 : null;
                    if (psiMethod == null || psiSuperInterface.findMethodBySignature(psiMethodToCheck = psiMethod, true) == null) continue;
                    return 2;
                }
                return 0;
            }
        };
    }

    @NotNull
    protected String getDestinationPackageRecentKey() {
        return DESTINATION_PACKAGE_RECENT_KEY;
    }

    @NotNull
    protected String getClassNameLabelText() {
        String string = RefactoringBundle.message((String)"interface.name.prompt");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected String getPackageNameLabelText() {
        String string = RefactoringBundle.message((String)"package.for.new.interface");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected String getEntityName() {
        String string = RefactoringBundle.message((String)"extractSuperInterface.interface");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected String getTopLabelText() {
        String string = RefactoringBundle.message((String)"extract.interface.from");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected int getDocCommentPolicySetting() {
        return KotlinRefactoringSettings.Companion.getInstance().EXTRACT_INTERFACE_JAVADOC;
    }

    protected void setDocCommentPolicySetting(int policy) {
        KotlinRefactoringSettings.Companion.getInstance().EXTRACT_INTERFACE_JAVADOC = policy;
    }

    @NotNull
    protected String getExtractedSuperNameNotSpecifiedMessage() {
        String string = RefactoringBundle.message((String)"no.interface.name.specified");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected String getHelpId() {
        return "refactoring.extractInterface";
    }

    @Override
    @NotNull
    protected JTextField createExtractedSuperNameField() {
        JTextField jTextField;
        JTextField $this$createExtractedSuperNameField_u24lambda_u243 = jTextField = super.createExtractedSuperNameField();
        boolean bl = false;
        $this$createExtractedSuperNameField_u24lambda_u243.setText("I" + this.getOriginalClass().getName());
        return jTextField;
    }

    private static final List createMemberInfoModel$lambda$2(KotlinExtractInterfaceDialog this$0) {
        return this$0.getSelectedMembers();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractInterfaceDialog$Companion;", "", "<init>", "()V", "DESTINATION_PACKAGE_RECENT_KEY", "", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

