/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.idea.quickfix.AddAnnotationFix;
import org.jetbrains.kotlin.idea.quickfix.OptInFixes;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&JD\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0005J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00122\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0006\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInGeneralUtilsBase;", "", "<init>", "()V", "isSubclassOptPropagateApplicable", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "collectPropagateOptInAnnotationFix", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix;", "targetElement", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "applicableTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "actualTargetList", "", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "isOverrideError", "collectUseOptInAnnotationFix", "Lcom/intellij/modcommand/ModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "optInClassId", "collectCandidates", "Lorg/jetbrains/kotlin/idea/quickfix/OptInGeneralUtilsBase$CandidateData;", "element", "Lcom/intellij/psi/PsiElement;", "findContainingDeclarationCandidate", "findContainingClassOrObjectCandidate", "CandidateData", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\nOptInGeneralUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInGeneralUtils.kt\norg/jetbrains/kotlin/idea/quickfix/OptInGeneralUtilsBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n2746#2,3:107\n1#3:110\n*S KotlinDebug\n*F\n+ 1 OptInGeneralUtils.kt\norg/jetbrains/kotlin/idea/quickfix/OptInGeneralUtilsBase\n*L\n32#1:107,3\n*E\n"})
public abstract class OptInGeneralUtilsBase {
    public abstract boolean isSubclassOptPropagateApplicable(@NotNull KtDeclaration var1, @NotNull FqName var2);

    @Nullable
    public final AddAnnotationFix collectPropagateOptInAnnotationFix(@NotNull KtDeclaration targetElement, @NotNull AddAnnotationFix.Kind kind2, @NotNull Set<? extends KotlinTarget> applicableTargets, @NotNull List<? extends KotlinTarget> actualTargetList, @NotNull ClassId annotationClassId, boolean isOverrideError) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            Intrinsics.checkNotNullParameter(applicableTargets, (String)"applicableTargets");
            Intrinsics.checkNotNullParameter(actualTargetList, (String)"actualTargetList");
            Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
            if (KtPsiUtil.isLocal((KtDeclaration)targetElement)) {
                return null;
            }
            Iterable $this$none$iv = actualTargetList;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KotlinTarget it = (KotlinTarget)element$iv;
                    boolean bl2 = false;
                    if (!applicableTargets.contains(it)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        FqName annotationFqName = annotationClassId.asSingleFqName();
        return isOverrideError ? (AddAnnotationFix)new OptInFixes.PropagateOptInAnnotationFix(targetElement, annotationClassId, kind2, null, PriorityAction.Priority.HIGH) : (this.isSubclassOptPropagateApplicable(targetElement, annotationFqName) ? (AddAnnotationFix)new OptInFixes.PropagateOptInAnnotationFix(targetElement, ClassId.Companion.topLevel(OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME()), kind2, annotationFqName, null, 16, null) : (AddAnnotationFix)new OptInFixes.PropagateOptInAnnotationFix(targetElement, annotationClassId, kind2, null, null, 24, null));
    }

    @NotNull
    public final ModCommandAction collectUseOptInAnnotationFix(@NotNull KtElement targetElement, @NotNull AddAnnotationFix.Kind kind2, @NotNull ClassId optInClassId, @NotNull FqName annotationFqName, boolean isOverrideError) {
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)optInClassId, (String)"optInClassId");
        Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
        KtAnnotated ktAnnotated = targetElement instanceof KtAnnotated ? (KtAnnotated)targetElement : null;
        KtAnnotationEntry existingAnnotationEntry = ktAnnotated != null ? AnnotationModificationUtilsKt.findAnnotation$default(ktAnnotated, optInClassId, null, false, 6, null) : null;
        PriorityAction.Priority priority = isOverrideError ? PriorityAction.Priority.NORMAL : PriorityAction.Priority.HIGH;
        return existingAnnotationEntry != null ? (ModCommandAction)new OptInFixes.ModifyOptInAnnotationFix(existingAnnotationEntry, kind2, annotationFqName, priority) : (ModCommandAction)new OptInFixes.UseOptInAnnotationFix(targetElement, optInClassId, kind2, annotationFqName, priority);
    }

    @NotNull
    public final List<CandidateData> collectCandidates(@NotNull PsiElement element) {
        List result2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            result2 = new ArrayList();
            Class[] classArray = new Class[]{KtDeclarationWithBody.class, KtClassOrObject.class, KtProperty.class, KtTypeAlias.class};
            KtDeclaration ktDeclaration = (KtDeclaration)PsiUtilsKt.getParentOfTypesAndPredicate((PsiElement)element, (boolean)false, (Class[])classArray, OptInGeneralUtilsBase::collectCandidates$lambda$1);
            if (ktDeclaration == null) {
                return CollectionsKt.emptyList();
            }
            KtDeclaration containingDeclaration = ktDeclaration;
            CandidateData containingDeclarationCandidate = this.findContainingDeclarationCandidate(containingDeclaration);
            result2.add(containingDeclarationCandidate);
            if (!(containingDeclaration instanceof KtCallableDeclaration)) break block2;
            CandidateData candidateData = this.findContainingClassOrObjectCandidate(containingDeclaration);
            if (candidateData != null) {
                CandidateData p0 = candidateData;
                boolean bl = false;
                result2.add(p0);
            }
        }
        return result2;
    }

    @NotNull
    public final CandidateData findContainingDeclarationCandidate(@NotNull KtDeclaration element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        AddAnnotationFix.Kind kind2 = element instanceof KtConstructor ? (AddAnnotationFix.Kind)AddAnnotationFix.Kind.Constructor.INSTANCE : (AddAnnotationFix.Kind)new AddAnnotationFix.Kind.Declaration(element.getName());
        return new CandidateData((KtElement)element, kind2);
    }

    @Nullable
    public final CandidateData findContainingClassOrObjectCandidate(@NotNull KtDeclaration element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtClassOrObject ktClassOrObject = element instanceof KtClassOrObject ? (KtClassOrObject)element : null;
        if (ktClassOrObject == null && (ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)element)) == null) {
            return null;
        }
        KtClassOrObject containingClassOrObject = ktClassOrObject;
        return new CandidateData((KtElement)containingClassOrObject, new AddAnnotationFix.Kind.ContainingClass(containingClassOrObject.getName()));
    }

    private static final boolean collectCandidates$lambda$1(KtDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !KtPsiUtil.isLocal((KtDeclaration)it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInGeneralUtilsBase$CandidateData;", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;)V", "getElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "getKind", "()Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.fir.frontend-independent"})
    public static final class CandidateData {
        @NotNull
        private final KtElement element;
        @NotNull
        private final AddAnnotationFix.Kind kind;

        public CandidateData(@NotNull KtElement element, @NotNull AddAnnotationFix.Kind kind2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            this.element = element;
            this.kind = kind2;
        }

        @NotNull
        public final KtElement getElement() {
            return this.element;
        }

        @NotNull
        public final AddAnnotationFix.Kind getKind() {
            return this.kind;
        }

        @NotNull
        public final KtElement component1() {
            return this.element;
        }

        @NotNull
        public final AddAnnotationFix.Kind component2() {
            return this.kind;
        }

        @NotNull
        public final CandidateData copy(@NotNull KtElement element, @NotNull AddAnnotationFix.Kind kind2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            return new CandidateData(element, kind2);
        }

        public static /* synthetic */ CandidateData copy$default(CandidateData candidateData, KtElement ktElement, AddAnnotationFix.Kind kind2, int n, Object object) {
            if ((n & 1) != 0) {
                ktElement = candidateData.element;
            }
            if ((n & 2) != 0) {
                kind2 = candidateData.kind;
            }
            return candidateData.copy(ktElement, kind2);
        }

        @NotNull
        public String toString() {
            return "CandidateData(element=" + this.element + ", kind=" + this.kind + ")";
        }

        public int hashCode() {
            int result2 = this.element.hashCode();
            result2 = result2 * 31 + this.kind.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CandidateData)) {
                return false;
            }
            CandidateData candidateData = (CandidateData)other;
            if (!Intrinsics.areEqual((Object)this.element, (Object)candidateData.element)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.kind, (Object)candidateData.kind);
        }
    }
}

