/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.inspections.migration.DeprecatedForKotlinLibInfo;
import org.jetbrains.kotlin.idea.inspections.migration.KotlinxVersionUpdaterKt;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.PomFileKt;
import org.jetbrains.kotlin.idea.maven.inspections.MavenCoroutinesDeprecationInspectionKt;
import org.jetbrains.kotlin.idea.migration.MigrationInfo;
import org.jetbrains.kotlin.idea.migration.MigrationInfoKt;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrationFix;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/MavenCoroutinesDeprecationInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrationFix;", "<init>", "()V", "isApplicable", "", "migrationInfo", "Lorg/jetbrains/kotlin/idea/migration/MigrationInfo;", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "kotlin.maven"})
@SourceDebugExtension(value={"SMAP\nMavenCoroutinesDeprecationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenCoroutinesDeprecationInspection.kt\norg/jetbrains/kotlin/idea/maven/inspections/MavenCoroutinesDeprecationInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1563#2:110\n1634#2,3:111\n*S KotlinDebug\n*F\n+ 1 MavenCoroutinesDeprecationInspection.kt\norg/jetbrains/kotlin/idea/maven/inspections/MavenCoroutinesDeprecationInspection\n*L\n52#1:110\n52#1:111,3\n*E\n"})
public final class MavenCoroutinesDeprecationInspection
extends DomElementsInspection<MavenDomProjectModel>
implements CleanupLocalInspectionTool,
MigrationFix {
    public MavenCoroutinesDeprecationInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @Override
    public boolean isApplicable(@NotNull MigrationInfo migrationInfo) {
        Intrinsics.checkNotNullParameter((Object)migrationInfo, (String)"migrationInfo");
        return MigrationInfoKt.isLanguageVersionUpdate(migrationInfo, LanguageVersion.KOTLIN_1_2, LanguageVersion.KOTLIN_1_3);
    }

    /*
     * WARNING - void declaration
     */
    public void checkFileElement(@NotNull DomFileElement<MavenDomProjectModel> domFileElement, @NotNull DomElementAnnotationHolder holder2) {
        Intrinsics.checkNotNullParameter(domFileElement, (String)"domFileElement");
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        XmlFile xmlFile = domFileElement.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        XmlFile file = xmlFile;
        Module module = domFileElement.getModule();
        if (module == null) {
            return;
        }
        Module module2 = module;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module2.getProject());
        if (mavenProjectsManager == null) {
            return;
        }
        MavenProjectsManager manager = mavenProjectsManager;
        MavenProject mavenProject = manager.findProject(module2);
        if (mavenProject == null) {
            return;
        }
        MavenProject mavenProject2 = mavenProject;
        PomFile pomFile = PomFile.Companion.forFileOrNull(file);
        if (pomFile == null) {
            return;
        }
        PomFile pomFile2 = pomFile;
        for (DeprecatedForKotlinLibInfo deprecatedLibInfo : KotlinxVersionUpdaterKt.getDEPRECATED_COROUTINES_LIBRARIES_INFORMATION()) {
            String versionStr;
            if (!MavenCoroutinesDeprecationInspectionKt.access$checkKotlinVersion(module2, deprecatedLibInfo.getSinceKotlinLanguageVersion())) {
                return;
            }
            MavenId libMavenId = new MavenId(deprecatedLibInfo.getLib().getGroupId(), deprecatedLibInfo.getLib().getName(), null);
            for (MavenDomDependency dependency : PomFile.findDependencies$default(pomFile2, libMavenId, null, 2, null)) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = mavenProject2.findDependencies(deprecatedLibInfo.getLib().getGroupId(), deprecatedLibInfo.getLib().getName());
                boolean $i$f$map = false;
                void var16_16 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MavenArtifact mavenArtifact = (MavenArtifact)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getVersion());
                }
                versionStr = (String)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
                if (versionStr == null) continue;
                MavenCoroutinesDeprecationInspectionKt.access$reportDependency(dependency, versionStr, deprecatedLibInfo, holder2);
            }
            MavenDomDependencies mavenDomDependencies = pomFile2.getDomModel().getDependencyManagement().getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"getDependencies(...)");
            for (MavenDomDependency dependency : PomFileKt.findDependencies$default(mavenDomDependencies, libMavenId, null, 2, null)) {
                GenericDomValue genericDomValue = dependency.getVersion();
                versionStr = genericDomValue != null ? genericDomValue.getStringValue() : null;
                if (versionStr == null) continue;
                MavenCoroutinesDeprecationInspectionKt.access$reportDependency(dependency, versionStr, deprecatedLibInfo, holder2);
            }
        }
    }
}

