/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.inline;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.utils.ControlFlowUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.inline.KotlinInlineNamedFunctionDialog;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinInlineFunctionHandler;
import org.jetbrains.kotlin.idea.refactoring.inline.codeInliner.InlineUtilsKt;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/inline/KotlinInlineFunctionHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineFunctionHandler;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "<init>", "()V", "canInlineKotlinFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "inlineKotlinFunction", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.refactorings.k2"})
@SourceDebugExtension(value={"SMAP\nKotlinInlineFunctionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinInlineFunctionHandler.kt\norg/jetbrains/kotlin/idea/k2/refactoring/inline/KotlinInlineFunctionHandler\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,53:1\n73#2:54\n*S KotlinDebug\n*F\n+ 1 KotlinInlineFunctionHandler.kt\norg/jetbrains/kotlin/idea/k2/refactoring/inline/KotlinInlineFunctionHandler\n*L\n43#1:54\n*E\n"})
public final class KotlinInlineFunctionHandler
extends AbstractKotlinInlineFunctionHandler<KtNamedFunction> {
    @Override
    public boolean canInlineKotlinFunction(@NotNull KtFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return function instanceof KtNamedFunction && ((KtNamedFunction)function).getNameIdentifier() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inlineKotlinFunction(@NotNull Project project, @Nullable Editor editor, @NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Editor editor2 = editor;
        PsiReference nameReference = editor2 != null ? InlineUtilsKt.findSimpleNameReference(editor2) : null;
        boolean recursive = ControlFlowUtilsKt.isRecursive(function);
        if (recursive && nameReference == null) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)KotlinBundle.message((String)"text.inline.recursive.function.is.supported.only.on.references", (Object[])new Object[0]));
            Intrinsics.checkNotNull((Object)message2);
            this.showErrorHint(project, editor, message2);
            return;
        }
        KotlinInlineNamedFunctionDialog dialog2 = new KotlinInlineNamedFunctionDialog(function, nameReference, editor, recursive);
        boolean $i$f$isUnitTestMode = false;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            dialog2.show();
        } else {
            try {
                dialog2.doAction();
            }
            finally {
                dialog2.close(0, true);
            }
        }
    }
}

