/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.scratch;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesModificationTracker;
import org.jetbrains.kotlin.idea.core.script.ScriptRelatedModuleNameFile;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFileListener;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFileModuleInfoProvider;", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFileListener;", "<init>", "()V", "fileCreated", "", "file", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;", "Companion", "kotlin.jvm.shared"})
@SourceDebugExtension(value={"SMAP\nScratchFileModuleInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchFileModuleInfoProvider.kt\norg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFileModuleInfoProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,47:1\n1#2:48\n14#3:49\n*S KotlinDebug\n*F\n+ 1 ScratchFileModuleInfoProvider.kt\norg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFileModuleInfoProvider\n*L\n16#1:49\n*E\n"})
public final class ScratchFileModuleInfoProvider
implements ScratchFileListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    public void fileCreated(@NotNull ScratchFile file) {
        block8: {
            String string;
            block10: {
                block9: {
                    Project project;
                    VirtualFile virtualFile;
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        KtFile ktFile2 = file.getKtFile();
                        if (ktFile2 == null) {
                            return;
                        }
                        KtFile ktFile3 = ktFile2;
                        VirtualFile virtualFile2 = ktFile3.getVirtualFile();
                        if (virtualFile2 == null) {
                            return;
                        }
                        virtualFile = virtualFile2;
                        Project project2 = ktFile3.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                        project = project2;
                        if (!Intrinsics.areEqual((Object)virtualFile.getExtension(), (Object)KotlinParserDefinition.STD_SCRIPT_SUFFIX)) {
                            LOG.error("Kotlin Scratch file should have .kts extension. Cannot add scratch panel for " + virtualFile.getPath());
                            return;
                        }
                        file.addModuleListener((Function2<? super PsiFile, ? super Module, Unit>)((Function2)(arg_0, arg_1) -> ScratchFileModuleInfoProvider.fileCreated$lambda$1(project, arg_0, arg_1)));
                        if (!ScratchUtilsKt.isKotlinWorksheet(virtualFile)) break block7;
                        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
                        if (module == null) {
                            return;
                        }
                        Module module2 = module;
                        file.setModule(module2);
                        break block8;
                    }
                    string = ScriptRelatedModuleNameFile.Companion.get(project, virtualFile);
                    if (string == null) break block9;
                    String it = string;
                    boolean bl = false;
                    Module module = ModuleManager.Companion.getInstance(project).findModuleByName(it);
                    string = module;
                    if (module != null) break block10;
                }
                return;
            }
            String module = string;
            file.setModule((Module)module);
        }
    }

    private static final Unit fileCreated$lambda$1$lambda$0(Project $project, PsiFile $psiFile) {
        DaemonCodeAnalyzer.getInstance((Project)$project).restart($psiFile);
        return Unit.INSTANCE;
    }

    private static final Unit fileCreated$lambda$1(Project $project, PsiFile psiFile, Module module) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Module module2 = module;
        ScriptRelatedModuleNameFile.Companion.set($project, virtualFile, module2 != null ? module2.getName() : null);
        ScriptDependenciesModificationTracker.Companion.getInstance($project).incModificationCount();
        ActionsKt.runReadAction(() -> ScratchFileModuleInfoProvider.fileCreated$lambda$1$lambda$0($project, psiFile));
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ScratchFileModuleInfoProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFileModuleInfoProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.jvm.shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

