/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k.post.processing.processings;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.InspectionLikeProcessingForElement;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/processings/RemoveJavaStreamsCollectCallTypeArgumentsProcessing;", "Lorg/jetbrains/kotlin/j2k/InspectionLikeProcessingForElement;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "<init>", "()V", "isApplicableTo", "", "element", "settings", "Lorg/jetbrains/kotlin/j2k/ConverterSettings;", "apply", "", "Companion", "kotlin.j2k.k1.new.post-processing"})
public final class RemoveJavaStreamsCollectCallTypeArgumentsProcessing
extends InspectionLikeProcessingForElement<KtCallExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FqName COLLECT_FQ_NAME = new FqName("java.util.stream.Stream.collect");

    public RemoveJavaStreamsCollectCallTypeArgumentsProcessing() {
        super(KtCallExpression.class);
    }

    @Override
    protected boolean isApplicableTo(@NotNull KtCallExpression element, @NotNull ConverterSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        if (element.getTypeArgumentList() == null) {
            return false;
        }
        KtExpression ktExpression = element.getCalleeExpression();
        if (!Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)COLLECT_FQ_NAME.shortName().getIdentifier())) {
            return false;
        }
        return FunctionUtilsKt.isCalling$default(element, COLLECT_FQ_NAME, null, 2, null);
    }

    @Override
    protected void apply(@NotNull KtCallExpression element) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            KtTypeArgumentList ktTypeArgumentList = element.getTypeArgumentList();
            if (ktTypeArgumentList == null) break block0;
            ktTypeArgumentList.delete();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/processings/RemoveJavaStreamsCollectCallTypeArgumentsProcessing$Companion;", "", "<init>", "()V", "COLLECT_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.j2k.k1.new.post-processing"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

