/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.loopToCallChain.sequence;

import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ChainedCallGenerator;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.MatchingState;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.SequenceTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.TransformationMatch;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.TransformationMatcher;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.sequence.MapTransformation;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/sequence/FlatMapTransformation;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/SequenceTransformation;", "loop", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "inputVariable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "transform", "Lorg/jetbrains/kotlin/psi/KtExpression;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtForExpression;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getLoop", "()Lorg/jetbrains/kotlin/psi/KtForExpression;", "getInputVariable", "()Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getTransform", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "affectsIndex", "", "getAffectsIndex", "()Z", "presentation", "", "getPresentation", "()Ljava/lang/String;", "generateCode", "chainedCallGenerator", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ChainedCallGenerator;", "Matcher", "kotlin.idea"})
public final class FlatMapTransformation
implements SequenceTransformation {
    @NotNull
    private final KtForExpression loop;
    @NotNull
    private final KtCallableDeclaration inputVariable;
    @NotNull
    private final KtExpression transform;

    public FlatMapTransformation(@NotNull KtForExpression loop, @NotNull KtCallableDeclaration inputVariable, @NotNull KtExpression transform2) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)inputVariable, (String)"inputVariable");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        this.loop = loop;
        this.inputVariable = inputVariable;
        this.transform = transform2;
    }

    @Override
    @NotNull
    public KtForExpression getLoop() {
        return this.loop;
    }

    @NotNull
    public final KtCallableDeclaration getInputVariable() {
        return this.inputVariable;
    }

    @NotNull
    public final KtExpression getTransform() {
        return this.transform;
    }

    @Override
    public boolean getAffectsIndex() {
        return true;
    }

    @Override
    @NotNull
    public String getPresentation() {
        return "flatMap{}";
    }

    @Override
    @NotNull
    public KtExpression generateCode(@NotNull ChainedCallGenerator chainedCallGenerator2) {
        Intrinsics.checkNotNullParameter((Object)chainedCallGenerator2, (String)"chainedCallGenerator");
        KtLambdaExpression lambda2 = UtilsKt.generateLambda(this.inputVariable, this.transform, chainedCallGenerator2.getReformat());
        Object[] objectArray = new Object[]{lambda2};
        return ChainedCallGenerator.generate$default(chainedCallGenerator2, "flatMap$0:'{}'", objectArray, null, false, 12, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/sequence/FlatMapTransformation$Matcher;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/TransformationMatcher;", "<init>", "()V", "indexVariableAllowed", "", "getIndexVariableAllowed", "()Z", "match", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/TransformationMatch$Sequence;", "state", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/MatchingState;", "asSequence", "Lorg/jetbrains/kotlin/psi/KtExpression;", "reformat", "kotlin.idea"})
    public static final class Matcher
    implements TransformationMatcher {
        @NotNull
        public static final Matcher INSTANCE = new Matcher();

        private Matcher() {
        }

        @Override
        public boolean getIndexVariableAllowed() {
            return true;
        }

        @Override
        @Nullable
        public TransformationMatch.Sequence match(@NotNull MatchingState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Object object = CollectionsKt.singleOrNull(state.getStatements());
            KtForExpression ktForExpression = object instanceof KtForExpression ? (KtForExpression)object : null;
            if (ktForExpression == null) {
                return null;
            }
            KtForExpression nestedLoop = ktForExpression;
            KtExpression ktExpression = nestedLoop.getLoopRange();
            if (ktExpression == null) {
                return null;
            }
            KtExpression transform2 = ktExpression;
            KotlinType kotlinType = ResolutionUtils.analyze((KtElement)transform2, BodyResolveMode.PARTIAL).getType(transform2);
            if (kotlinType == null) {
                return null;
            }
            KotlinType nestedSequenceType = kotlinType;
            KotlinBuiltIns builtIns = PlatformKt.getBuiltIns((KtElement)transform2);
            KotlinType kotlinType2 = builtIns.getIterableType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getIterableType(...)");
            List list2 = builtIns.getIterable().getDeclaredTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDeclaredTypeParameters(...)");
            FuzzyType iterableType = new FuzzyType(kotlinType2, list2);
            if (iterableType.checkIsSuperTypeOf(nestedSequenceType) == null) {
                return null;
            }
            KtExpression ktExpression2 = nestedLoop.getBody();
            if (ktExpression2 == null) {
                return null;
            }
            KtExpression nestedLoopBody = ktExpression2;
            KtParameter ktParameter = nestedLoop.getLoopParameter();
            if (ktParameter == null) {
                return null;
            }
            KtParameter newInputVariable = ktParameter;
            if (state.getIndexVariable() != null && org.jetbrains.kotlin.idea.codeinsights.impl.base.UtilsKt.hasUsages(state.getIndexVariable(), (KtElement)transform2)) {
                MapTransformation mapIndexedTransformation = new MapTransformation(state.getOuterLoop(), state.getInputVariable(), state.getIndexVariable(), transform2, false);
                Project project = nestedLoop.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)state.getInputVariable().getNameAsSafeName(), (String)"getNameAsSafeName(...)");
                KtExpression inputVarExpression = CreateByPatternKt.createExpressionByPattern((KtPsiFactory)ktPsiFactory, (String)"$0", (Object[])objectArray, (boolean)state.getReformat());
                KtExpression transformToUse = state.getLazySequence() ? this.asSequence(inputVarExpression, state.getReformat()) : inputVarExpression;
                FlatMapTransformation flatMapTransformation = new FlatMapTransformation(state.getOuterLoop(), state.getInputVariable(), transformToUse);
                MatchingState newState = MatchingState.copy$default(state, null, nestedLoop, CollectionsKt.listOf((Object)nestedLoopBody), (KtCallableDeclaration)newInputVariable, null, false, null, false, null, null, null, 2033, null);
                Object[] objectArray2 = new SequenceTransformation[]{mapIndexedTransformation, flatMapTransformation};
                return new TransformationMatch.Sequence((List<? extends SequenceTransformation>)CollectionsKt.listOf((Object[])objectArray2), newState);
            }
            KtExpression transformToUse = state.getLazySequence() ? this.asSequence(transform2, state.getReformat()) : transform2;
            FlatMapTransformation transformation = new FlatMapTransformation(state.getOuterLoop(), state.getInputVariable(), transformToUse);
            MatchingState newState = MatchingState.copy$default(state, null, nestedLoop, CollectionsKt.listOf((Object)nestedLoopBody), (KtCallableDeclaration)newInputVariable, null, false, null, false, null, null, null, 2033, null);
            return new TransformationMatch.Sequence(transformation, newState);
        }

        private final KtExpression asSequence(KtExpression $this$asSequence, boolean reformat) {
            Project project = $this$asSequence.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object[] objectArray = new Object[]{$this$asSequence};
            return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)"$0.asSequence()", (Object[])objectArray, (boolean)reformat);
        }
    }
}

