/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.base.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculator;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculatorKt;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculatorVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtScript;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/DefaultClassNameCalculator;", "Lorg/jetbrains/kotlin/idea/debugger/base/util/ClassNameCalculator;", "<init>", "()V", "getClassNames", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getClassName", "element", "getTopLevelNames", "", "kotlin.jvm-debugger.base.util"})
@SourceDebugExtension(value={"SMAP\nClassNameCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassNameCalculator.kt\norg/jetbrains/kotlin/idea/debugger/base/util/DefaultClassNameCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n808#2,11:229\n1617#2,9:240\n1869#2:249\n1870#2:251\n1626#2:252\n808#2,11:253\n1563#2:264\n1634#2,3:265\n1#3:250\n*S KotlinDebug\n*F\n+ 1 ClassNameCalculator.kt\norg/jetbrains/kotlin/idea/debugger/base/util/DefaultClassNameCalculator\n*L\n107#1:229,11\n107#1:240,9\n107#1:249\n107#1:251\n107#1:252\n108#1:253,11\n108#1:264\n108#1:265,3\n107#1:250\n*E\n"})
final class DefaultClassNameCalculator
implements ClassNameCalculator {
    @NotNull
    public static final DefaultClassNameCalculator INSTANCE = new DefaultClassNameCalculator();

    private DefaultClassNameCalculator() {
    }

    @Override
    @NotNull
    public Map<KtElement, String> getClassNames(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> DefaultClassNameCalculator.getClassNames$lambda$0(file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Map)object;
    }

    @Override
    @Nullable
    public String getClassName(@NotNull KtElement element) {
        KtElement ktElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof KtFunctionLiteral) {
            PsiElement psiElement = ((KtFunctionLiteral)element).getParent();
            KtLambdaExpression ktLambdaExpression = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
            if (ktLambdaExpression == null) {
                ktLambdaExpression = element;
            }
            ktElement = (KtElement)ktLambdaExpression;
        } else {
            ktElement = element;
        }
        KtElement target = ktElement;
        KtFile ktFile2 = element.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        return this.getClassNames(ktFile2).get(target);
    }

    @Override
    @NotNull
    public List<String> getTopLevelNames(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> DefaultClassNameCalculator.getTopLevelNames$lambda$3(file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    private static final CachedValueProvider.Result getClassNames$lambda$0(KtFile $file) {
        ClassNameCalculatorVisitor visitor2 = new ClassNameCalculatorVisitor();
        $file.accept((PsiElementVisitor)visitor2);
        Object[] objectArray = new Object[]{$file};
        return new CachedValueProvider.Result(visitor2.getAllNames(), objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final CachedValueProvider.Result getTopLevelNames$lambda$3(KtFile $file) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        List declarations2 = $file.getDeclarations();
        String fileName = ClassNameCalculatorKt.access$getFileFQN($file);
        Iterable $this$filterIsInstance$iv = declarations2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable<String> destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof KtClassLikeDeclaration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv2 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtClassLikeDeclaration it = (KtClassLikeDeclaration)element$iv$iv;
            boolean bl2 = false;
            ClassId classId = it.getClassId();
            if ((classId != null ? classId.asString() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List classNames = (List)destination$iv$iv;
        Iterable $this$filterIsInstance$iv2 = declarations2;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtScript)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (KtScript)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getFqName().asString());
        }
        List scriptNames = (List)destination$iv$iv2;
        List allNames = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)classNames, (Iterable)scriptNames), (Iterable)CollectionsKt.listOf((Object)fileName));
        Object[] objectArray = new Object[]{$file};
        return new CachedValueProvider.Result((Object)allNames, objectArray);
    }
}

