/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k2.notifications;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.ScriptResidenceExceptionProviderKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.core.script.k2.notifications.ScriptingSupportCheckerKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k2/notifications/ScriptingSupportChecker;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.base.scripting.k2"})
public final class ScriptingSupportChecker
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (DefinitionsKt.isNonScript(file)) {
            return null;
        }
        KtFile ktFile2 = ScriptingSupportCheckerKt.access$toKtFile(file, project);
        if (ktFile2 == null) {
            return null;
        }
        KtFile ktFile3 = ktFile2;
        boolean featureEnabled = ScriptResidenceExceptionProviderKt.isEnabled(LanguageFeature.SkipStandaloneScriptsInSourceRoots, GenericPsiUtils.getModule((PsiElement)ktFile3), project);
        if (featureEnabled && !ScriptResidenceExceptionProviderKt.compilerAllowsAnyScriptsInSourceRoots(project) && ScriptingSupportCheckerKt.access$isUnderSourceRoot(file, project) && ScriptResidenceExceptionProviderKt.isStandaloneKotlinScript(file, project) && ScriptResidenceExceptionProviderKt.hasNoExceptionsToBeUnderSourceRoot(file)) {
            return arg_0 -> ScriptingSupportChecker.collectNotificationData$lambda$2(file, project, arg_0);
        }
        return null;
    }

    private static final void collectNotificationData$lambda$2$lambda$1$lambda$0() {
        BrowserUtil.browse((String)KotlinBundle.message((String)"kotlin.script.in.project.sources.link", (Object[])new Object[0]));
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$2(VirtualFile $file, Project $project, FileEditor it) {
        EditorNotificationPanel editorNotificationPanel;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EditorNotificationPanel $this$collectNotificationData_u24lambda_u242_u24lambda_u241 = editorNotificationPanel = new EditorNotificationPanel(it, EditorNotificationPanel.Status.Warning);
        boolean bl = false;
        $this$collectNotificationData_u24lambda_u242_u24lambda_u241.setText(KotlinBundle.message((String)"kotlin.script.in.project.sources.1.9", (Object[])new Object[0]));
        $this$collectNotificationData_u24lambda_u242_u24lambda_u241.createActionLabel(KotlinBundle.message((String)"kotlin.script.warning.more.info", (Object[])new Object[0]), ScriptingSupportChecker::collectNotificationData$lambda$2$lambda$1$lambda$0, false);
        ScriptingSupportCheckerKt.access$addMoveOutOfSourceRootAction($this$collectNotificationData_u24lambda_u242_u24lambda_u241, $file, $project);
        return editorNotificationPanel;
    }
}

