/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fe10.highlighting.suspender;

import com.intellij.diagnostic.VMOptions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableWithId;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.fe10.highlighting.suspender.KotlinHighlightingSuspender;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinBaseHighlightingBundle;
import org.jetbrains.kotlin.idea.util.FileUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J,\u0010\u0006\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\b\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/base/fe10/highlighting/suspender/KotlinHighlightingSuspendNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "canSwitchKotlinPluginModeViaUI", "", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.highlighting.k1"})
public final class KotlinHighlightingSuspendNotificationProvider
implements EditorNotificationProvider {
    private final boolean canSwitchKotlinPluginModeViaUI() {
        return VMOptions.canWriteOptions();
    }

    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!FileUtils.isKotlinFileType(file)) {
            return null;
        }
        if (!KotlinHighlightingSuspender.Companion.getInstance(project).isSuspended(file)) {
            return null;
        }
        return arg_0 -> KotlinHighlightingSuspendNotificationProvider.collectNotificationData$lambda$4(file, this, project, arg_0);
    }

    private static final boolean collectNotificationData$lambda$4$lambda$3$lambda$1$lambda$0(Configurable it) {
        ConfigurableWithId configurableWithId = it instanceof ConfigurableWithId ? (ConfigurableWithId)it : null;
        return Intrinsics.areEqual((Object)(configurableWithId != null ? configurableWithId.getId() : null), (Object)"preferences.language.Kotlin");
    }

    private static final void collectNotificationData$lambda$4$lambda$3$lambda$1(Project $project) {
        ShowSettingsUtil.getInstance().showSettingsDialog($project, KotlinHighlightingSuspendNotificationProvider::collectNotificationData$lambda$4$lambda$3$lambda$1$lambda$0, null);
    }

    private static final void collectNotificationData$lambda$4$lambda$3$lambda$2(Project $project, VirtualFile $file) {
        KotlinHighlightingSuspender.Companion.getInstance($project).unsuspend($file);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$4(VirtualFile $file, KotlinHighlightingSuspendNotificationProvider this$0, Project $project, FileEditor it) {
        EditorNotificationPanel editorNotificationPanel;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EditorNotificationPanel $this$collectNotificationData_u24lambda_u244_u24lambda_u243 = editorNotificationPanel = new EditorNotificationPanel(it, EditorNotificationPanel.Status.Warning);
        boolean bl = false;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)$file.getName(), (String)"getName(...)");
        $this$collectNotificationData_u24lambda_u244_u24lambda_u243.setText(KotlinBaseHighlightingBundle.message("highlighting.for.0.is.suspended", objectArray));
        if (this$0.canSwitchKotlinPluginModeViaUI()) {
            $this$collectNotificationData_u24lambda_u244_u24lambda_u243.createActionLabel(KotlinBaseHighlightingBundle.message("highlighting.action.text.try.k2", new Object[0]), () -> KotlinHighlightingSuspendNotificationProvider.collectNotificationData$lambda$4$lambda$3$lambda$1($project));
        }
        $this$collectNotificationData_u24lambda_u244_u24lambda_u243.createActionLabel(KotlinBaseHighlightingBundle.message("highlighting.action.text.ignore", new Object[0]), () -> KotlinHighlightingSuspendNotificationProvider.collectNotificationData$lambda$4$lambda$3$lambda$2($project, $file));
        return editorNotificationPanel;
    }
}

