/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.console.HistoryUpdateListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\tH\u0086\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u0017\u001a\u00020\u0014R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u0005j\b\u0012\u0004\u0012\u00020\u000e`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0018\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/console/CommandHistory;", "", "<init>", "()V", "entries", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/console/CommandHistory$Entry;", "Lkotlin/collections/ArrayList;", "value", "", "processedEntriesCount", "getProcessedEntriesCount", "()I", "listeners", "Lorg/jetbrains/kotlin/console/HistoryUpdateListener;", "getListeners", "()Ljava/util/ArrayList;", "get", "i", "addEntry", "", "entry", "lastUnprocessedEntry", "entryProcessed", "size", "getSize", "Entry", "kotlin.repl"})
@SourceDebugExtension(value={"SMAP\nCommandHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandHistory.kt\norg/jetbrains/kotlin/console/CommandHistory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1869#2,2:42\n*S KotlinDebug\n*F\n+ 1 CommandHistory.kt\norg/jetbrains/kotlin/console/CommandHistory\n*L\n23#1:42,2\n*E\n"})
public final class CommandHistory {
    @NotNull
    private final ArrayList<Entry> entries = new ArrayList();
    private int processedEntriesCount;
    @NotNull
    private final ArrayList<HistoryUpdateListener> listeners = new ArrayList();

    public final int getProcessedEntriesCount() {
        return this.processedEntriesCount;
    }

    @NotNull
    public final ArrayList<HistoryUpdateListener> getListeners() {
        return this.listeners;
    }

    @NotNull
    public final Entry get(int i2) {
        Entry entry = this.entries.get(i2);
        Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"get(...)");
        return entry;
    }

    public final void addEntry(@NotNull Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(entry);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HistoryUpdateListener it = (HistoryUpdateListener)element$iv;
            boolean bl = false;
            it.onNewEntry(entry);
        }
    }

    @Nullable
    public final Entry lastUnprocessedEntry() {
        return this.processedEntriesCount < this.getSize() ? this.get(this.processedEntriesCount) : null;
    }

    public final void entryProcessed() {
        int n = this.processedEntriesCount;
        this.processedEntriesCount = n + 1;
    }

    public final int getSize() {
        return this.entries.size();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/console/CommandHistory$Entry;", "", "entryText", "", "rangeInHistoryDocument", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;)V", "getEntryText", "()Ljava/lang/String;", "getRangeInHistoryDocument", "()Lcom/intellij/openapi/util/TextRange;", "kotlin.repl"})
    public static final class Entry {
        @NotNull
        private final String entryText;
        @NotNull
        private final TextRange rangeInHistoryDocument;

        public Entry(@NotNull String entryText, @NotNull TextRange rangeInHistoryDocument) {
            Intrinsics.checkNotNullParameter((Object)entryText, (String)"entryText");
            Intrinsics.checkNotNullParameter((Object)rangeInHistoryDocument, (String)"rangeInHistoryDocument");
            this.entryText = entryText;
            this.rangeInHistoryDocument = rangeInHistoryDocument;
        }

        @NotNull
        public final String getEntryText() {
            return this.entryText;
        }

        @NotNull
        public final TextRange getRangeInHistoryDocument() {
            return this.rangeInHistoryDocument;
        }
    }
}

