/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.fir.utils.KaFirCacheCleaner;
import org.jetbrains.kotlin.analysis.api.platform.KaCachedService;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionInvalidationService;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.LLStatisticsService;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.domains.LLAnalysisSessionStatistics;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\b\u0010)\u001a\u00020'H\u0002J\b\u0010*\u001a\u00020'H\u0002J\b\u0010+\u001a\u00020'H\u0002J\b\u0010,\u001a\u00020'H\u0016J\b\u0010-\u001a\u00020'H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR!\u0010\u0010\u001a\u00020\u00118BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u000f\u0012\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u001a\u001aB\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001e0\u001e \u001d* \u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001e0\u001e\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirStopWorldCacheCleaner;", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirCacheCleaner;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lock", "", "analysisSessionStatistics", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLAnalysisSessionStatistics;", "getAnalysisSessionStatistics$annotations", "()V", "getAnalysisSessionStatistics", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLAnalysisSessionStatistics;", "analysisSessionStatistics$delegate", "Lkotlin/Lazy;", "invalidationService", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationService;", "getInvalidationService$annotations", "getInvalidationService", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationService;", "invalidationService$delegate", "analyzerCount", "", "analyzerDepth", "Ljava/lang/ThreadLocal;", "threadsWithAnalyze", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Ljava/lang/Thread;", "kotlin.jvm.PlatformType", "", "cleanupLatch", "Ljava/util/concurrent/CountDownLatch;", "cleanupScheduleMs", "", "hasOngoingAnalysis", "getHasOngoingAnalysis", "()Z", "enterAnalysis", "", "exitAnalysis", "waitForCleanupIfNeeded", "incAnalysisDepth", "decAnalysisDepth", "scheduleCleanup", "performCleanup", "Companion", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKaFirCacheCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaFirCacheCleaner.kt\norg/jetbrains/kotlin/analysis/api/fir/utils/KaFirStopWorldCacheCleaner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,310:1\n1#2:311\n53#3,4:312\n53#3,4:319\n53#3,4:323\n53#3,4:330\n11#3:334\n2746#4,3:316\n29#5,3:327\n*S KotlinDebug\n*F\n+ 1 KaFirCacheCleaner.kt\norg/jetbrains/kotlin/analysis/api/fir/utils/KaFirStopWorldCacheCleaner\n*L\n163#1:312,4\n240#1:319,4\n279#1:323,4\n302#1:330,4\n70#1:334\n238#1:316,3\n297#1:327,3\n*E\n"})
public final class KaFirStopWorldCacheCleaner
implements KaFirCacheCleaner {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Object lock;
    @NotNull
    private final Lazy analysisSessionStatistics$delegate;
    @NotNull
    private final Lazy invalidationService$delegate;
    private volatile int analyzerCount;
    @NotNull
    private final ThreadLocal<Integer> analyzerDepth;
    private final ConcurrentHashMap.KeySetView<Thread, Boolean> threadsWithAnalyze;
    @Nullable
    private volatile CountDownLatch cleanupLatch;
    private volatile long cleanupScheduleMs;
    @NotNull
    private static final Logger LOG;
    private static final long CACHE_CLEANER_LOCK_TIMEOUT_MS = 50L;

    public KaFirStopWorldCacheCleaner(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.lock = new Object();
        this.analysisSessionStatistics$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaFirStopWorldCacheCleaner.analysisSessionStatistics_delegate$lambda$0(this));
        this.invalidationService$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaFirStopWorldCacheCleaner.invalidationService_delegate$lambda$1(this));
        ThreadLocal<Integer> threadLocal = ThreadLocal.withInitial(KaFirStopWorldCacheCleaner::analyzerDepth$lambda$2);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        this.analyzerDepth = threadLocal;
        this.threadsWithAnalyze = ConcurrentHashMap.newKeySet();
    }

    private final LLAnalysisSessionStatistics getAnalysisSessionStatistics() {
        Lazy lazy = this.analysisSessionStatistics$delegate;
        return (LLAnalysisSessionStatistics)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getAnalysisSessionStatistics$annotations() {
    }

    private final LLFirSessionInvalidationService getInvalidationService() {
        Lazy lazy = this.invalidationService$delegate;
        return (LLFirSessionInvalidationService)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getInvalidationService$annotations() {
    }

    private final boolean getHasOngoingAnalysis() {
        return ((Number)this.analyzerDepth.get()).intValue() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enterAnalysis() {
        if (this.getHasOngoingAnalysis()) {
            this.incAnalysisDepth();
            return;
        }
        this.waitForCleanupIfNeeded();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            ++this.analyzerCount;
            boolean bl2 = this.threadsWithAnalyze.add(Thread.currentThread());
        }
        this.incAnalysisDepth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitAnalysis() {
        this.decAnalysisDepth();
        if (this.getHasOngoingAnalysis()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            CountDownLatch existingLatch;
            boolean bl = false;
            --this.analyzerCount;
            this.threadsWithAnalyze.remove(Thread.currentThread());
            if (!(this.analyzerCount >= 0)) {
                boolean $i$a$-require-KaFirStopWorldCacheCleaner$exitAnalysis$1$22 = false;
                String $i$a$-require-KaFirStopWorldCacheCleaner$exitAnalysis$1$22 = "Inconsistency in analyzer block counter";
                throw new IllegalArgumentException($i$a$-require-KaFirStopWorldCacheCleaner$exitAnalysis$1$22.toString());
            }
            if (this.cleanupLatch != null) {
                Logger $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl2 = false;
                    logger.trace("Analysis complete in " + Thread.currentThread() + ", " + this.analyzerCount + " left before the K2 cache cleanup");
                }
            }
            if (this.analyzerCount == 0 && (existingLatch = this.cleanupLatch) != null) {
                try {
                    this.performCleanup();
                }
                finally {
                    existingLatch.countDown();
                    this.cleanupLatch = null;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void waitForCleanupIfNeeded() {
        CountDownLatch countDownLatch = this.cleanupLatch;
        if (countDownLatch == null) {
            return;
        }
        CountDownLatch existingLatch = countDownLatch;
        long enterTime = System.currentTimeMillis();
        do {
            boolean bl;
            block5: {
                ProgressManager.checkCanceled();
                ConcurrentHashMap.KeySetView<Thread, Boolean> keySetView = this.threadsWithAnalyze;
                Intrinsics.checkNotNullExpressionValue(keySetView, (String)"threadsWithAnalyze");
                Iterable $this$none$iv = keySetView;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Thread it = (Thread)element$iv;
                        boolean bl2 = false;
                        if (!(it.getState() == Thread.State.RUNNABLE)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            long totalMs = System.currentTimeMillis() - enterTime;
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if (!$this$trace$iv.isTraceEnabled()) break;
            Logger logger = $this$trace$iv;
            boolean bl3 = false;
            logger.trace("A deadlock detected in K2 cache cleanup, " + Thread.currentThread() + " is recovered after " + totalMs + " ms");
            break;
        } while (!existingLatch.await(50L, TimeUnit.MILLISECONDS));
    }

    private final void incAnalysisDepth() {
        this.analyzerDepth.set(((Number)this.analyzerDepth.get()).intValue() + 1);
    }

    private final void decAnalysisDepth() {
        boolean bl;
        Integer oldValue = this.analyzerDepth.get();
        boolean bl2 = bl = oldValue > 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Inconsistency in analysis depth counter";
            throw new AssertionError((Object)string);
        }
        this.analyzerDepth.set(oldValue - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleCleanup() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            CountDownLatch existingLatch = this.cleanupLatch;
            if (this.analyzerCount == 0) {
                this.cleanupScheduleMs = System.currentTimeMillis();
                try {
                    this.performCleanup();
                }
                finally {
                    if (existingLatch != null) {
                        existingLatch.countDown();
                        this.cleanupLatch = null;
                        LOG.error("K2 cache cleanup was expected to happen right after the last analysis block completion");
                    }
                }
            } else if (existingLatch == null) {
                Logger $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl2 = false;
                    logger.trace("K2 cache cleanup scheduled from " + Thread.currentThread() + ", " + this.analyzerCount + " analyses left");
                }
                this.cleanupScheduleMs = System.currentTimeMillis();
                this.cleanupLatch = new CountDownLatch(1);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void performCleanup() {
        try {
            LLAnalysisSessionStatistics lLAnalysisSessionStatistics = this.getAnalysisSessionStatistics();
            if (lLAnalysisSessionStatistics != null && (lLAnalysisSessionStatistics = lLAnalysisSessionStatistics.getLowMemoryCacheCleanupInvocationCounter()) != null) {
                lLAnalysisSessionStatistics.add(1L);
            }
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            this.getInvalidationService().invalidateAll(true);
            long cleanupMs = System.currentTimeMillis() - start$iv;
            long totalMs = System.currentTimeMillis() - this.cleanupScheduleMs;
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace("K2 cache cleanup complete from " + Thread.currentThread() + " in " + cleanupMs + " ms (" + totalMs + " ms after the request)");
            }
        }
        catch (Throwable e) {
            PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded((Throwable)e);
            LOG.error("Could not clean up K2 caches", e);
        }
    }

    private static final LLAnalysisSessionStatistics analysisSessionStatistics_delegate$lambda$0(KaFirStopWorldCacheCleaner this$0) {
        LLStatisticsService lLStatisticsService = LLStatisticsService.Companion.getInstance(this$0.project);
        return lLStatisticsService != null ? lLStatisticsService.getAnalysisSessions() : null;
    }

    private static final LLFirSessionInvalidationService invalidationService_delegate$lambda$1(KaFirStopWorldCacheCleaner this$0) {
        return LLFirSessionInvalidationService.Companion.getInstance(this$0.project);
    }

    private static final Integer analyzerDepth$lambda$2() {
        return 0;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KaFirStopWorldCacheCleaner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirStopWorldCacheCleaner$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "CACHE_CLEANER_LOCK_TIMEOUT_MS", "", "analysis-api-fir"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

